/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.common.magic_link.packet;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.crypt.NanoID;
import group.aelysium.rustyconnector.common.errors.Error;
import group.aelysium.rustyconnector.common.magic_link.MagicLinkCore;
import group.aelysium.rustyconnector.common.magic_link.packet.PacketListener;
import group.aelysium.rustyconnector.common.magic_link.packet.PacketType;
import group.aelysium.rustyconnector.common.util.JSONParseable;
import group.aelysium.rustyconnector.common.util.Parameter;
import group.aelysium.rustyconnector.shaded.com.google.code.gson.gson.Gson;
import group.aelysium.rustyconnector.shaded.com.google.code.gson.gson.JsonObject;
import group.aelysium.rustyconnector.shaded.com.google.code.gson.gson.JsonPrimitive;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Packet
implements JSONParseable {
    protected static final int protocolVersion = 3;
    protected final int messageVersion;
    protected final Instant created = Instant.now();
    protected final Type type;
    protected final SourceIdentifier local;
    protected final SourceIdentifier remote;
    protected final Map<String, Parameter> parameters;
    protected boolean successful = false;
    protected String statusMessage = "The packet was parsed properly but has not been processed in any way.";
    protected NanoID cacheID = null;

    public int messageVersion() {
        return this.messageVersion;
    }

    public SourceIdentifier local() {
        return this.local;
    }

    @NotNull
    public SourceIdentifier remote() {
        return this.remote;
    }

    @NotNull
    public Type type() {
        return this.type;
    }

    @NotNull
    public Map<String, Parameter> parameters() {
        return this.parameters;
    }

    public boolean replying() {
        return this.remote().replyEndpoint().isPresent();
    }

    @NotNull
    public Instant created() {
        return this.created;
    }

    public boolean successful() {
        return this.successful;
    }

    @NotNull
    public String statusMessage() {
        return this.statusMessage;
    }

    @Nullable
    public NanoID cacheID() {
        return this.cacheID;
    }

    public abstract boolean isLocal();

    private Packet(@NotNull Integer version, @NotNull Type type, @NotNull SourceIdentifier local, @NotNull SourceIdentifier remote, @NotNull Map<String, Parameter> parameters) {
        this.messageVersion = version;
        this.type = type;
        this.local = local;
        this.remote = remote;
        this.parameters = parameters;
    }

    public void status(boolean successful, @Nullable String message) {
        this.successful = successful;
        this.statusMessage = message == null ? "No message was provided for this status." : message;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    @Override
    public JsonObject toJSON() {
        JsonObject object = new JsonObject();
        object.add("v", new JsonPrimitive(this.messageVersion));
        object.add("i", new JsonPrimitive(this.type.toString()));
        object.add("s", this.local.toJSON());
        object.add("t", this.remote.toJSON());
        JsonObject parameters = new JsonObject();
        this.parameters.forEach((key, value) -> parameters.add((String)key, value.toJSON()));
        object.add("p", parameters);
        return object;
    }

    public static Builder New() {
        return new Builder();
    }

    public static Remote parseIncoming(String rawMessage) {
        Gson gson = new Gson();
        JsonObject messageObject = gson.fromJson(rawMessage, JsonObject.class);
        NakedBuilder builder = new NakedBuilder();
        builder.protocolVersion(messageObject.get("v").getAsInt());
        builder.type(new Type(messageObject.get("i").getAsString()));
        builder.local(SourceIdentifier.fromJSON(messageObject.get("s").getAsJsonObject()));
        builder.remote(SourceIdentifier.fromJSON(messageObject.get("t").getAsJsonObject()));
        messageObject.get("p").getAsJsonObject().entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            Parameter value = Parameter.fromUnknown(entry.getValue());
            builder.parameter(key, value);
        });
        return builder.buildRemote();
    }

    public static class SourceIdentifier
    implements JSONParseable {
        private final String id;
        private final Origin origin;
        private NanoID replyEndpoint;

        private SourceIdentifier(String id, @NotNull Origin origin) {
            this.id = id;
            this.origin = origin;
        }

        public String id() {
            return this.id;
        }

        public Origin origin() {
            return this.origin;
        }

        public void replyEndpoint(NanoID replyEndpoint) {
            this.replyEndpoint = replyEndpoint;
        }

        public Optional<NanoID> replyEndpoint() {
            return Optional.ofNullable(this.replyEndpoint);
        }

        @Override
        public JsonObject toJSON() {
            JsonObject object = new JsonObject();
            if (this.id != null) {
                object.add("u", new JsonPrimitive(this.id));
            }
            object.add("n", new JsonPrimitive(Origin.toInteger(this.origin)));
            if (this.replyEndpoint != null) {
                object.add("r", new JsonPrimitive(this.replyEndpoint.toString()));
            }
            return object;
        }

        public static SourceIdentifier fromJSON(JsonObject object) {
            SourceIdentifier source = new SourceIdentifier(object.get("u") == null ? null : object.get("u").getAsString(), Origin.fromInteger(object.get("n").getAsInt()));
            if (object.get("r") != null) {
                source.replyEndpoint(NanoID.fromString(object.get("r").getAsString()));
            }
            return source;
        }

        public static SourceIdentifier from(@NotNull String namespace, @NotNull Origin origin) {
            return new SourceIdentifier(namespace, origin);
        }

        public static SourceIdentifier server(@NotNull String id) {
            return new SourceIdentifier(id, Origin.SERVER);
        }

        public static SourceIdentifier proxy(@NotNull String id) {
            return new SourceIdentifier(id, Origin.PROXY);
        }

        public static SourceIdentifier allAvailableProxies() {
            return new SourceIdentifier(null, Origin.ANY_PROXY);
        }

        public static SourceIdentifier allAvailableServers() {
            return new SourceIdentifier(null, Origin.ANY_SERVER);
        }

        public static SourceIdentifier localSource() {
            try {
                SourceIdentifier source = SourceIdentifier.server(RC.S.Kernel().id());
                source.replyEndpoint(NanoID.randomNanoID());
                return source;
            }
            catch (Exception source) {
                try {
                    SourceIdentifier source2 = SourceIdentifier.proxy(RC.P.Kernel().id());
                    source2.replyEndpoint(NanoID.randomNanoID());
                    return source2;
                }
                catch (Exception exception) {
                    throw new RuntimeException("No available kernel existed in order to get your local source! How did you even fuck up bad enough to get this exception?");
                }
            }
        }

        public boolean isEquivalent(SourceIdentifier target) {
            if (Objects.equals(this, target)) {
                return true;
            }
            return this.origin == Origin.ANY_PROXY && target.origin == Origin.PROXY || this.origin == Origin.PROXY && target.origin == Origin.ANY_PROXY || this.origin == Origin.ANY_PROXY && target.origin == Origin.ANY_PROXY || this.origin == Origin.ANY_SERVER && target.origin == Origin.SERVER || this.origin == Origin.SERVER && target.origin == Origin.ANY_SERVER || this.origin == Origin.ANY_SERVER && target.origin == Origin.ANY_SERVER;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SourceIdentifier target = (SourceIdentifier)o;
            return Objects.equals(this.id, target.id) && Objects.equals((Object)this.origin, (Object)target.origin);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.origin});
        }

        public static enum Origin {
            PROXY,
            ANY_PROXY,
            SERVER,
            ANY_SERVER;


            public static Origin fromInteger(int number) {
                return switch (number) {
                    case 0 -> PROXY;
                    case 1 -> ANY_PROXY;
                    case 2 -> SERVER;
                    case 3 -> ANY_SERVER;
                    default -> throw new ClassCastException(number + " has no associated value!");
                };
            }

            public static int toInteger(Origin origin) {
                return switch (origin.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> 0;
                    case 1 -> 1;
                    case 2 -> 2;
                    case 3 -> 3;
                };
            }
        }
    }

    public static class Type {
        protected String id;

        public Type(String id) {
            this.id = id;
        }

        public String type() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Type mapping = (Type)o;
            return Objects.equals(this.id, mapping.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public static Type from(@NotNull String namespace, @NotNull String packetID) throws IllegalArgumentException {
            String idToCheck = namespace.toUpperCase();
            if (idToCheck.isEmpty()) {
                throw new IllegalArgumentException("pluginID can't be empty!");
            }
            if (packetID.isEmpty()) {
                throw new IllegalArgumentException("packetID can't be empty!");
            }
            return new Type(namespace + "-" + packetID);
        }

        public static Type parseString(@NotNull String value) throws IllegalArgumentException {
            String[] tokens = value.split("-");
            if (tokens.length > 2) {
                throw new IllegalArgumentException("Invalid type passed.");
            }
            return new Type(value.toUpperCase());
        }
    }

    static interface Parameters {
        public static final String PROTOCOL_VERSION = "v";
        public static final String IDENTIFICATION = "i";
        public static final String LOCAL = "s";
        public static final String REMOTE = "t";
        public static final String PARAMETERS = "p";
    }

    public static class Builder {
        private final NakedBuilder builder = new NakedBuilder();

        protected Builder() {
        }

        public PrepareForSending identification(Type id) {
            return new PrepareForSending(this.builder.type(id));
        }

        public static class PrepareForSending {
            private final NakedBuilder builder;

            protected PrepareForSending(NakedBuilder builder) {
                this.builder = builder;
            }

            public PrepareForSending parameter(String key, String value) {
                this.builder.parameter(key, new Parameter(value));
                return this;
            }

            public PrepareForSending parameter(String key, Parameter value) {
                this.builder.parameter(key, value);
                return this;
            }

            public ReadyForSending addressTo(SourceIdentifier remote) {
                this.builder.local(SourceIdentifier.localSource());
                this.builder.remote(remote);
                return new ReadyForSending(this.builder);
            }

            public ReadyForSending addressTo(Packet targetPacket) {
                this.builder.local(SourceIdentifier.localSource());
                this.builder.remote(targetPacket.local());
                return new ReadyForSending(this.builder);
            }
        }

        public static class ReadyForSending {
            private final NakedBuilder builder;

            protected ReadyForSending(NakedBuilder builder) {
                this.builder = builder;
            }

            public Local send() throws RuntimeException {
                Local packet = this.builder.buildLocal();
                MagicLinkCore magicLink = RC.MagicLink();
                magicLink.publish(packet);
                return packet;
            }
        }
    }

    protected static class NakedBuilder {
        private Integer protocolVersion = 3;
        private Type type;
        private SourceIdentifier local;
        private SourceIdentifier remote;
        private final Map<String, Parameter> parameters = new HashMap<String, Parameter>();

        protected NakedBuilder() {
        }

        public NakedBuilder type(@NotNull Type type) {
            this.type = type;
            return this;
        }

        public NakedBuilder local(@NotNull SourceIdentifier local) {
            this.local = local;
            return this;
        }

        public NakedBuilder remote(@NotNull SourceIdentifier remote) {
            this.remote = remote;
            return this;
        }

        public NakedBuilder parameter(@NotNull String key, @NotNull String value) {
            this.parameters.put(key, new Parameter(value));
            return this;
        }

        public NakedBuilder parameter(@NotNull String key, @NotNull Parameter value) {
            this.parameters.put(key, value);
            return this;
        }

        protected NakedBuilder protocolVersion(int protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Remote buildRemote() {
            return new Remote(this.protocolVersion, this.type, this.local, this.remote, this.parameters);
        }

        public Local buildLocal() {
            return new Local(this.protocolVersion, this.type, this.local, this.remote, this.parameters);
        }
    }

    public static class Remote
    extends Packet {
        public Remote(@NotNull Integer version, @NotNull Type type, @NotNull SourceIdentifier sender, @NotNull SourceIdentifier target, @NotNull Map<String, Parameter> parameters) {
            super(version, type, sender, target, parameters);
        }

        public Remote(@NotNull Packet packet) {
            this(packet.messageVersion, packet.type, packet.local, packet.remote, packet.parameters);
        }

        @Override
        public final boolean isLocal() {
            return false;
        }

        public NanoID id() {
            return this.local.replyEndpoint;
        }

        @Override
        public SourceIdentifier local() {
            return super.local();
        }

        @Override
        @NotNull
        public SourceIdentifier remote() {
            return super.remote();
        }

        @NotNull
        public Local reply(@NotNull PacketListener.Response response) {
            Builder.PrepareForSending prepareForSending = Packet.New().identification(Type.from("RC", "R")).parameter("s", new Parameter(this.successful)).parameter("r", response.message);
            response.parameters.forEach(prepareForSending::parameter);
            return prepareForSending.addressTo(this).send();
        }
    }

    public static class Local
    extends Packet {
        private Vector<PacketListener.Function<Remote, PacketListener.Response>> catchAlls = null;
        private ConcurrentHashMap<Class<? extends Remote>, Vector<PacketListener.Function<Remote, PacketListener.Response>>> replyListeners = null;
        private ConcurrentHashMap<Type, Class<? extends Remote>> packetTypeMappings = null;

        public Local(@NotNull Integer version, @NotNull Type type, @NotNull SourceIdentifier sender, @NotNull SourceIdentifier target, @NotNull Map<String, Parameter> parameters) {
            super(version, type, sender, target, parameters);
        }

        public Local(@NotNull Packet packet) {
            this(packet.messageVersion, packet.type, packet.local, packet.remote, packet.parameters);
        }

        @Override
        public final boolean isLocal() {
            return true;
        }

        public <P extends Remote> void handleReply(P packet) throws Exception {
            if (this.replyListeners == null && this.catchAlls == null) {
                packet.status(false, "No listeners exist to handle this packet.");
                return;
            }
            if (this.catchAlls != null) {
                this.catchAlls.forEach((Consumer<PacketListener.Function<Remote, PacketListener.Response>>)((Consumer<PacketListener.Function>)l -> {
                    try {
                        PacketListener.Response response = (PacketListener.Response)l.apply(packet);
                        packet.status(response.successful, response.message);
                        if (response.shouldSendPacket) {
                            packet.reply(response);
                        }
                    }
                    catch (Throwable e) {
                        RC.Error(Error.from(e));
                        packet.status(false, e.getMessage());
                    }
                }));
            }
            if (this.replyListeners != null && this.packetTypeMappings != null) {
                Class<? extends Remote> wrapperClass = this.packetTypeMappings.get(packet.type());
                if (wrapperClass == null) {
                    return;
                }
                Remote wrapped = wrapperClass.getConstructor(Packet.class).newInstance(packet);
                this.replyListeners.get(wrapperClass).forEach((Consumer<PacketListener.Function<Remote, PacketListener.Response>>)((Consumer<PacketListener.Function>)l -> {
                    try {
                        PacketListener.Response response = (PacketListener.Response)l.apply(wrapped);
                        packet.status(response.successful, response.message);
                        if (response.shouldSendPacket()) {
                            packet.reply(response);
                        }
                    }
                    catch (Throwable e) {
                        RC.Error(Error.from(e));
                        packet.status(false, e.getMessage());
                    }
                }));
            }
        }

        public void onReply(@NotNull PacketListener.Function<? extends Remote, PacketListener.Response> handler) {
            if (this.catchAlls == null) {
                this.catchAlls = new Vector();
            }
            this.catchAlls.add(handler);
            RC.MagicLink().awaitReply(this);
        }

        public <T extends Remote> void onReply(@NotNull Class<T> clazz, @NotNull PacketListener.Function<T, PacketListener.Response> handler) {
            if (!clazz.isAnnotationPresent(PacketType.class)) {
                RC.Error(Error.from("Packet classes used for PacketListeners must be annotated with @PacketType.").whileAttempting("To register a new packet listener."));
                return;
            }
            PacketType annotation = clazz.getAnnotation(PacketType.class);
            if (this.packetTypeMappings == null) {
                this.packetTypeMappings = new ConcurrentHashMap();
            }
            this.packetTypeMappings.putIfAbsent(Type.parseString(annotation.value()), clazz);
            if (this.replyListeners == null) {
                this.replyListeners = new ConcurrentHashMap();
            }
            this.replyListeners.computeIfAbsent(clazz, k -> new Vector()).add(handler);
            RC.MagicLink().awaitReply(this);
        }
    }
}

