/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.common.magic_link.packet;

import group.aelysium.rustyconnector.common.magic_link.packet.Packet;
import group.aelysium.rustyconnector.common.util.Parameter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface PacketListener {
    public Class<? extends Packet.Remote> value();

    public boolean responseFromExceptions() default true;

    public boolean responsesAsPacketReplies() default false;

    public static class Response {
        public final boolean successful;
        public final String message;
        public final Map<String, Parameter> parameters;
        protected boolean shouldSendPacket = false;

        protected Response(boolean successful, @NotNull String message, @NotNull Map<String, Parameter> parameters) {
            this.successful = successful;
            this.message = message;
            this.parameters = parameters;
        }

        public boolean shouldSendPacket() {
            return this.shouldSendPacket;
        }

        public static Response success(@NotNull String message) {
            return Response.success(message, Map.of());
        }

        public static Response success(@NotNull String message, @NotNull Map<String, Parameter> parameters) {
            return new Response(true, message, parameters);
        }

        public static Response error(@NotNull String message) {
            return Response.error(message, Map.of());
        }

        public static Response error(@NotNull String message, @NotNull Map<String, Parameter> parameters) {
            return new Response(false, message, parameters);
        }

        public static Response canceled() {
            return Response.error("The action performed by this packet has been canceled.");
        }

        public Response asReply() {
            this.shouldSendPacket = true;
            return this;
        }
    }

    @FunctionalInterface
    public static interface Function<T, R> {
        public R apply(T var1) throws Exception;
    }
}

