/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.common.modules;

import group.aelysium.rustyconnector.common.modules.Module;
import group.aelysium.rustyconnector.common.modules.ModuleHolder;
import group.aelysium.rustyconnector.shaded.group.aelysium.ara.Closure;
import group.aelysium.rustyconnector.shaded.group.aelysium.ara.Flux;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public class ModuleCollection<P extends Module>
implements Closure,
ModuleHolder<P> {
    protected final Map<String, Flux<P>> modules = new ConcurrentHashMap<String, Flux<P>>();

    @NotNull
    public Module registerModule(Module.Builder<? extends P> builder) throws Exception {
        return this.registerModule(builder.name, builder);
    }

    @NotNull
    public P registerModule(@NotNull String key, Module.Builder<? extends P> builder) throws Exception {
        Flux<P> flux = Flux.using(builder);
        if (this.modules.containsKey(key.toLowerCase())) {
            throw new IllegalStateException("A module with the name " + key.toLowerCase() + " was already registered.");
        }
        flux.metadata("name", builder.name);
        flux.metadata("description", builder.description);
        flux.build();
        Module p = (Module)flux.get(1, TimeUnit.MINUTES);
        this.modules.put(key.toLowerCase(), flux);
        return (P)p;
    }

    public void unregisterModule(@NotNull String name) {
        try {
            Flux<P> plugin = this.modules.get(name);
            plugin.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <T extends P> Flux<T> fetchModule(String name) {
        return this.modules.get(name.toLowerCase());
    }

    public boolean containsModule(String name) {
        return this.modules.containsKey(name.toLowerCase());
    }

    @Override
    public void close() throws Exception {
        this.modules.forEach((? super K k, ? super V v) -> {
            try {
                v.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.modules.clear();
    }

    @Override
    public Map<String, Flux<P>> modules() {
        return Collections.unmodifiableMap(this.modules);
    }

    public int size() {
        return this.modules.size();
    }

    public boolean isEmpty() {
        return this.modules.isEmpty();
    }

    public void forEach(BiConsumer<String, Flux<?>> consumer) {
        this.modules.forEach(consumer);
    }
}

