/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.common.modules;

import group.aelysium.rustyconnector.common.modules.ModuleLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModuleDependencyResolver {
    public static List<String> sortPlugins(Set<ModuleLoader.ModuleRegistrar> moduleRegistrars) throws IllegalArgumentException {
        HashMap<String, ModuleLoader.ModuleRegistrar> configs = new HashMap<String, ModuleLoader.ModuleRegistrar>();
        moduleRegistrars.forEach(t -> configs.put(t.name().toLowerCase(), (ModuleLoader.ModuleRegistrar)t));
        HashMap<String, Integer> inDegree = new HashMap<String, Integer>();
        HashMap graph = new HashMap();
        configs.forEach((k, v) -> {
            String key = k.toLowerCase();
            inDegree.put(key, 0);
            graph.put(key, new ArrayList());
        });
        HashSet missingDependencies = new HashSet();
        configs.forEach((k, v) -> {
            String key = k.toLowerCase();
            v.dependencies().forEach(dep -> {
                String depKey = dep.toLowerCase();
                if (!configs.containsKey(depKey)) {
                    missingDependencies.add(key);
                    inDegree.put(key, -1);
                    return;
                }
                ((List)graph.get(depKey)).add(key);
                inDegree.put(key, (Integer)inDegree.get(key) + 1);
            });
            v.softDependencies().forEach(softDep -> {
                String softDepKey = softDep.toLowerCase();
                if (!configs.containsKey(softDepKey)) {
                    return;
                }
                ((List)graph.get(softDepKey)).add(key);
                inDegree.put(key, (Integer)inDegree.get(key) + 1);
            });
        });
        LinkedList<String> queue = new LinkedList<String>();
        for (Map.Entry entry : inDegree.entrySet()) {
            if ((Integer)entry.getValue() != 0) continue;
            queue.add((String)entry.getKey());
        }
        ArrayList<String> sortedList = new ArrayList<String>();
        while (!queue.isEmpty()) {
            String current = (String)queue.poll();
            sortedList.add(current);
            for (String neighbor : (List)graph.get(current)) {
                inDegree.put(neighbor, (Integer)inDegree.get(neighbor) - 1);
                if ((Integer)inDegree.get(neighbor) != 0) continue;
                queue.add(neighbor);
            }
        }
        HashSet<String> circularDependencies = new HashSet<String>();
        for (Map.Entry entry : inDegree.entrySet()) {
            if ((Integer)entry.getValue() <= 0) continue;
            circularDependencies.add((String)entry.getKey());
        }
        if (!missingDependencies.isEmpty()) {
            System.out.println("The following plugins have missing dependencies and were not loaded: " + String.join((CharSequence)", ", missingDependencies));
        }
        if (!circularDependencies.isEmpty()) {
            System.out.println("The following plugins have circular dependencies and were not loaded: " + String.join((CharSequence)", ", circularDependencies));
        }
        return sortedList;
    }
}

