/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.common.modules;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.RCKernel;
import group.aelysium.rustyconnector.common.errors.Error;
import group.aelysium.rustyconnector.common.modules.ExternalModuleBuilder;
import group.aelysium.rustyconnector.common.modules.Module;
import group.aelysium.rustyconnector.common.modules.ModuleClassLoader;
import group.aelysium.rustyconnector.common.modules.ModuleDependencyResolver;
import group.aelysium.rustyconnector.proxy.ProxyKernel;
import group.aelysium.rustyconnector.server.ServerKernel;
import group.aelysium.rustyconnector.shaded.com.google.code.gson.gson.Gson;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleLoader
implements AutoCloseable {
    protected Gson gson = new Gson();
    protected final List<ModuleClassLoader> classLoaders = new ArrayList<ModuleClassLoader>();
    private final Map<String, ModuleRegistrar> registrars = new HashMap<String, ModuleRegistrar>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueFromFolder(String modulesDirectory) {
        System.out.println("Loading modules.");
        File modules = new File(modulesDirectory);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            File[] files;
            if (!modules.exists()) {
                modules.mkdirs();
            }
            if ((files = modules.listFiles((dir, name) -> name.endsWith(".jar"))) == null) {
                return;
            }
            for (File file : files) {
                try {
                    ModuleConfiguration config;
                    ModuleClassLoader resourceGrabber = new ModuleClassLoader(List.of(file.toURI().toURL()), this.getClass().getClassLoader(), List.of());
                    InputStream stream = resourceGrabber.getResourceAsStream("rc-module.json");
                    if (stream == null) {
                        throw new NullPointerException("No rc-module.json exists for " + file.getName());
                    }
                    try (InputStreamReader reader = new InputStreamReader(stream);){
                        config = this.gson.fromJson((Reader)reader, ModuleConfiguration.class);
                    }
                    resourceGrabber.close();
                    ModuleClassLoader classLoader = new ModuleClassLoader(List.of(file.toURI().toURL()), this.getClass().getClassLoader(), config.sharedPackages == null ? List.of() : config.sharedPackages);
                    Thread.currentThread().setContextClassLoader(classLoader);
                    Class<?> entrypoint = classLoader.loadClass(config.main());
                    if (!ExternalModuleBuilder.class.isAssignableFrom(entrypoint)) {
                        throw new ClassCastException("The `main` class must extend " + ExternalModuleBuilder.class.getName());
                    }
                    Constructor<?> constructor = entrypoint.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    final ExternalModuleBuilder plugin = (ExternalModuleBuilder)constructor.newInstance(new Object[0]);
                    constructor.setAccessible(false);
                    String lowerConfigName = config.name().toLowerCase();
                    if (this.registrars.containsKey(lowerConfigName)) {
                        throw new IllegalStateException("Duplicate module names '" + config.name() + "' are not allowed! Ignoring " + file.getName());
                    }
                    final ArrayList<String> softDeps = new ArrayList<String>(Stream.of(config.softDependencies(), config.softDependency(), config.softDepend()).filter(Objects::nonNull).flatMap(Collection::stream).distinct().toList());
                    List<String> deps = Stream.of(config.dependencies(), config.dependency(), config.depend()).filter(Objects::nonNull).flatMap(Collection::stream).distinct().toList();
                    if (softDeps.isEmpty() && deps.isEmpty()) {
                        softDeps.add("MagicLink");
                    }
                    Consumer<RCKernel<?>> registerRunnable = k -> {
                        try {
                            String environment;
                            String string = k instanceof ServerKernel ? "server" : (environment = k instanceof ProxyKernel ? "proxy" : "other");
                            if (!config.environments.contains(environment)) {
                                RC.Error(Error.from(config.name() + " does not support '" + environment + "' environments! " + config.name() + " only supports: " + String.join((CharSequence)", ", config.environments)).urgent(true));
                                return;
                            }
                            Module m = k.registerModule(new Module.Builder<Module>(config.name(), config.description()){

                                @Override
                                public Module get() {
                                    try {
                                        return plugin.onStart(new ExternalModuleBuilder.Context(config.name(), config.description(), Set.copyOf(config.environments()), softDeps.stream().filter(ModuleLoader.this.registrars::containsKey).collect(Collectors.toSet()), environment, k.moduleDirectory(), k.directory()));
                                    }
                                    catch (Exception e) {
                                        RC.Error(Error.from(e).whileAttempting("To register " + config.name()).urgent(true));
                                        return null;
                                    }
                                }
                            });
                            try {
                                if (k instanceof ServerKernel) {
                                    ServerKernel s = (ServerKernel)k;
                                    plugin.bind(s, m);
                                }
                                if (k instanceof ProxyKernel) {
                                    ProxyKernel p = (ProxyKernel)k;
                                    plugin.bind(p, m);
                                }
                            }
                            catch (Exception e) {
                                RC.Error(Error.from(e).whileAttempting("To bind " + config.name() + " to the kernel.").urgent(true));
                                k.unregisterModule(config.name());
                            }
                        }
                        catch (Exception e) {
                            RC.Error(Error.from(e).whileAttempting("To register the module: " + lowerConfigName));
                        }
                    };
                    this.registrars.put(lowerConfigName, new ModuleRegistrar(lowerConfigName, registerRunnable, deps, softDeps));
                }
                catch (Exception e) {
                    RC.Error(Error.from(e).whileAttempting("To register the module: " + file.getName()));
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
            }
        }
        catch (Exception e) {
            RC.Error(Error.from(e).whileAttempting("To register external modules via `" + modules.getAbsolutePath() + "`"));
        }
        finally {
            System.out.println("Done loading modules.");
        }
    }

    public void queue(ModuleRegistrar registrar) {
        this.registrars.put(registrar.name.toLowerCase(), registrar);
    }

    public void resolveAndRegister(RCKernel<?> kernel) {
        List<String> order = ModuleDependencyResolver.sortPlugins(Set.copyOf(this.registrars.values()));
        order.forEach(o -> {
            System.out.println("Loading " + o);
            try {
                ModuleRegistrar registrar = this.registrars.get(o.toLowerCase());
                registrar.register().accept(kernel);
            }
            catch (Exception e) {
                RC.Error(Error.from(e).whileAttempting("To register the module `" + o + "`"));
            }
        });
        this.registrars.clear();
    }

    @Override
    public void close() throws Exception {
        this.classLoaders.forEach(c -> {
            try {
                c.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private record ModuleConfiguration(@NotNull String main, @NotNull String name, @NotNull String description, @NotNull List<String> environments, @Nullable List<String> sharedPackages, @Nullable List<String> dependencies, @Nullable List<String> dependency, @Nullable List<String> depend, @Nullable List<String> softDependencies, @Nullable List<String> softDependency, @Nullable List<String> softDepend) {
    }

    public record ModuleRegistrar(String name, Consumer<RCKernel<?>> register, List<String> dependencies, List<String> softDependencies) {
        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModuleRegistrar moduleRegistrar = (ModuleRegistrar)o;
            return Objects.equals(this.name, moduleRegistrar.name);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.name);
        }
    }
}

