/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.common.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class GeneratorMap<K, V> {
    private final Map<String, Function<K, V>> generators = new ConcurrentHashMap<String, Function<K, V>>();

    public void register(String name, Function<K, V> generator) {
        if (this.generators.containsKey(name.toLowerCase())) {
            throw new UnsupportedOperationException("Algorithm " + name.toUpperCase() + " already exists!");
        }
        this.generators.putIfAbsent(name, generator);
    }

    public void unregister(String name) {
        this.generators.remove(name.toLowerCase());
    }

    public Function<K, V> fetch(String name) {
        return this.generators.get(name);
    }
}

