/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.common.util;

import group.aelysium.rustyconnector.shaded.com.google.code.gson.gson.JsonArray;
import group.aelysium.rustyconnector.shaded.com.google.code.gson.gson.JsonElement;
import group.aelysium.rustyconnector.shaded.com.google.code.gson.gson.JsonObject;
import group.aelysium.rustyconnector.shaded.com.google.code.gson.gson.JsonPrimitive;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class Parameter {
    protected char type;
    protected Object object;

    private Parameter(@NotNull Object object, char type) {
        this.object = object;
        this.type = type;
    }

    public Parameter(@NotNull Number object) {
        this(object, 'n');
    }

    public Parameter(@NotNull Boolean object) {
        this(object, 'b');
    }

    public Parameter(@NotNull String object) {
        this(object, 's');
    }

    public Parameter(@NotNull JsonArray object) {
        this(object, 'a');
    }

    public Parameter(@NotNull JsonObject object) {
        this(object, 'j');
    }

    public static Parameter fromJSON(@NotNull JsonElement object) {
        if (object.isJsonPrimitive()) {
            JsonPrimitive primitive = object.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                try {
                    return new Parameter(primitive.getAsInt());
                }
                catch (Exception exception) {
                    try {
                        return new Parameter(primitive.getAsLong());
                    }
                    catch (Exception exception2) {
                        try {
                            return new Parameter(primitive.getAsDouble());
                        }
                        catch (Exception exception3) {
                            try {
                                return new Parameter(primitive.getAsShort());
                            }
                            catch (Exception exception4) {
                                try {
                                    return new Parameter(Float.valueOf(primitive.getAsFloat()));
                                }
                                catch (Exception exception5) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
            if (primitive.isBoolean()) {
                return new Parameter(primitive.getAsBoolean());
            }
            if (primitive.isString()) {
                return new Parameter(primitive.getAsString());
            }
        }
        if (object.isJsonArray()) {
            return new Parameter(object.getAsJsonArray());
        }
        if (object.isJsonObject()) {
            return new Parameter(object.getAsJsonObject());
        }
        throw new IllegalStateException("Unexpected value: " + object.getClass().getName());
    }

    public static Parameter fromUnknown(@NotNull Object object) {
        Class<?> clazz = object.getClass();
        if (Number.class.isAssignableFrom(clazz)) {
            return new Parameter((Number)object);
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return new Parameter((int)((Integer)object));
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return new Parameter((long)((Long)object));
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            return new Parameter((double)((Double)object));
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            return new Parameter(Float.valueOf(((Float)object).floatValue()));
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz)) {
            return new Parameter((short)((Short)object));
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return new Parameter((boolean)((Boolean)object));
        }
        if (String.class.isAssignableFrom(clazz)) {
            return new Parameter(String.valueOf(object));
        }
        if (JsonElement.class.isAssignableFrom(clazz)) {
            return Parameter.fromJSON((JsonElement)object);
        }
        throw new IllegalStateException("Unexpected value: " + object.getClass().getName());
    }

    public char type() {
        return this.type;
    }

    public int getAsInt() {
        return ((Number)this.object).intValue();
    }

    public long getAsLong() {
        return ((Number)this.object).longValue();
    }

    public double getAsDouble() {
        return ((Number)this.object).doubleValue();
    }

    public float getAsFloat() {
        return ((Number)this.object).floatValue();
    }

    public short getAsShort() {
        return ((Number)this.object).shortValue();
    }

    public boolean getAsBoolean() {
        return (Boolean)this.object;
    }

    public String getAsString() {
        return (String)this.object;
    }

    public UUID getStringAsUUID() {
        return UUID.fromString(this.getAsString());
    }

    public JsonArray getAsJsonArray() {
        return (JsonArray)this.object;
    }

    public JsonObject getAsJsonObject() {
        return (JsonObject)this.object;
    }

    public Object getOriginalValue() {
        return this.object;
    }

    public JsonElement toJSON() {
        return switch (this.type) {
            case 'n' -> new JsonPrimitive((Number)this.object);
            case 'b' -> new JsonPrimitive((Boolean)this.object);
            case 's' -> new JsonPrimitive((String)this.object);
            case 'a' -> (JsonArray)this.object;
            case 'j' -> (JsonObject)this.object;
            default -> throw new IllegalStateException("Unexpected value: " + this.type);
        };
    }
}

