/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.common.util;

import com.google.errorprone.annotations.Immutable;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class URL {
    private final Protocol protocol;
    private final String domain;
    private final Integer port;
    private final List<String> path;
    private final Map<String, String> query;
    private final String fragment;

    private URL(@NotNull Protocol protocol, @NotNull String domainName, @Nullable Integer port, @Nullable List<String> path, @Nullable Map<String, String> query, @Nullable String fragment) {
        this.protocol = protocol;
        this.domain = domainName;
        this.port = port;
        this.path = Collections.unmodifiableList(path == null ? new ArrayList() : path);
        this.query = Collections.unmodifiableMap(query == null ? Map.of() : query);
        this.fragment = fragment;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public String domain() {
        return this.domain;
    }

    public Integer port() {
        return this.port;
    }

    public List<String> path() {
        return this.path;
    }

    public Map<String, String> query() {
        return this.query;
    }

    public String fragment() {
        return this.fragment;
    }

    public URL copy() {
        return new URL(this.protocol, this.domain, this.port, this.path, this.query, this.fragment);
    }

    public URL prependPath(String path) {
        ArrayList<String> pathList = new ArrayList<String>();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        ArrayList<String> oldPath = new ArrayList<String>(this.path);
        if (path.contains("/")) {
            pathList.addAll(Arrays.stream(path.split("/")).toList());
        } else {
            pathList.add(path);
        }
        pathList.addAll(oldPath);
        return new URL(this.protocol, this.domain, this.port, pathList, this.query, this.fragment);
    }

    public URL appendPath(String path) {
        ArrayList<String> pathList = new ArrayList<String>();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.contains("/")) {
            pathList.addAll(Arrays.stream(path.split("/")).toList());
            return new URL(this.protocol, this.domain, this.port, pathList, this.query, this.fragment);
        }
        pathList.add(path);
        return new URL(this.protocol, this.domain, this.port, pathList, this.query, this.fragment);
    }

    public URL clearPath() {
        return new URL(this.protocol, this.domain, this.port, List.of(), this.query, this.fragment);
    }

    public URL changeProtocol(Protocol protocol) {
        return new URL(protocol, this.domain, this.port, this.path, this.query, this.fragment);
    }

    public URI toURI() {
        return URI.create(this.toString());
    }

    public String toString() {
        return this.protocol.name().toLowerCase() + "://" + String.join((CharSequence)".", this.domain) + (String)(this.port != null ? ":" + this.port : "") + "/" + (!this.path.isEmpty() ? String.join((CharSequence)"/", this.path) : "") + (String)(this.query != null && !this.query.isEmpty() ? "?" + String.join((CharSequence)"&", this.query.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"))) : "") + (String)(this.fragment != null ? "#" + this.fragment : "");
    }

    public static URL parseURL(String url2) throws ParseException {
        Map<String, String> parsedURL = Map.of("protocol", URL.extractPart("^([a-z]*):\\/\\/", url2), "domainName", URL.extractPart("\\:\\/\\/([^:/]*)", url2), "port", URL.extractPart(":(\\d+)", url2), "path", URL.extractPart(":\\d+(\\/[^?#]*)", url2), "query", URL.extractPart("\\?([^#]*)", url2), "fragment", URL.extractPart("#(.*)", url2));
        return new URL(Protocol.valueOf(parsedURL.get("protocol").toUpperCase()), parsedURL.get("domainName"), parsedURL.get("port").isEmpty() ? null : Integer.valueOf(Integer.parseInt(parsedURL.get("port"))), parsedURL.get("path").isEmpty() ? null : List.of(parsedURL.get("path").split("/")), parsedURL.get("query").isEmpty() ? null : Arrays.stream(parsedURL.get("query").split("&")).map(s -> s.split("=")).collect(Collectors.toMap(keyValue -> keyValue[0], keyValue -> keyValue[1])), parsedURL.get("fragment").isEmpty() ? null : parsedURL.get("fragment"));
    }

    private static String extractPart(String pattern, String url2) {
        Pattern compiledPattern = Pattern.compile(pattern);
        Matcher matcher = compiledPattern.matcher(url2);
        return matcher.find() ? matcher.group(1) : "";
    }

    public static enum Protocol {
        HTTP,
        HTTPS,
        FTP,
        FILE,
        DATA,
        WS,
        WSS,
        IRC,
        TCP;

    }
}

