/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.plugin.common.command;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.RustyConnector;
import group.aelysium.rustyconnector.common.RCAdapter;
import group.aelysium.rustyconnector.common.RCKernel;
import group.aelysium.rustyconnector.common.crypt.NanoID;
import group.aelysium.rustyconnector.common.errors.Error;
import group.aelysium.rustyconnector.common.magic_link.packet.Packet;
import group.aelysium.rustyconnector.common.modules.Module;
import group.aelysium.rustyconnector.common.modules.ModuleHolder;
import group.aelysium.rustyconnector.common.util.CommandClient;
import group.aelysium.rustyconnector.plugin.common.lang.CommonLang;
import group.aelysium.rustyconnector.shaded.group.aelysium.ara.Flux;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.Commands;
import org.incendo.cloud.annotations.Permission;
import org.jetbrains.annotations.Nullable;

@Command(value="rc")
@Permission(value={"rustyconnector.commands.rc"})
public class CommonCommands {
    @Command(value="")
    public void hizfafjjszjivcys(CommandClient.Console<?> client) {
        client.send(RC.Lang("rustyconnector-kernelDetails").generate(RC.Kernel()));
    }

    @Command(value="reload")
    public void nglbwcmuzzxvjaon(CommandClient.Console<?> client) {
        try {
            client.send(RC.Lang("rustyconnector-waiting").generate(new Object[0]));
            Flux<RCKernel<? extends RCAdapter>> particle = RustyConnector.Kernel();
            particle.rebuild();
            client.send(RC.Lang("rustyconnector-finished").generate(new Object[0]));
        }
        catch (Exception e) {
            RC.Error(Error.from(e).urgent(true));
        }
    }

    @Commands(value={@Command(value="plugin"), @Command(value="plugins"), @Command(value="module"), @Command(value="modules")})
    public void nglbwcmuvchdjaon(CommandClient.Console<?> client) {
        try {
            client.send(RC.Lang("rustyconnector-pluginList").generate(RC.Kernel().modules().keySet()));
        }
        catch (Exception e) {
            RC.Error(Error.from(e).urgent(true));
        }
    }

    @Commands(value={@Command(value="plugin <pluginTree>"), @Command(value="plugins <pluginTree>"), @Command(value="module <pluginTree>"), @Command(value="modules <pluginTree>")})
    public void nglbwcmuschdjaon(CommandClient.Console<?> client, String pluginTree) {
        try {
            Flux<Module> flux = CommonCommands.fetchPlugin(client, pluginTree);
            if (flux == null) {
                return;
            }
            client.send(RC.Lang("rustyconnector-details").generate(flux.metadata("name"), flux.metadata("description"), flux.asOptional()));
        }
        catch (Exception e) {
            RC.Error(Error.from(e).urgent(true));
        }
    }

    @Commands(value={@Command(value="plugin <pluginTree> reload"), @Command(value="plugins <pluginTree> reload"), @Command(value="module <pluginTree> reload"), @Command(value="modules <pluginTree> reload")})
    public void nglbwzmspchdjaon(CommandClient.Console<?> client, String pluginTree) {
        try {
            Flux<Module> flux = CommonCommands.fetchPlugin(client, pluginTree);
            if (flux == null) {
                return;
            }
            client.send(RC.Lang("rustyconnector-waiting").generate(new Object[0]));
            flux.rebuild();
            client.send(RC.Lang("rustyconnector-finished").generate(new Object[0]));
        }
        catch (Exception e) {
            RC.Error(Error.from(e).urgent(true));
        }
    }

    @Commands(value={@Command(value="plugin <pluginTree> stop"), @Command(value="plugins <pluginTree> stop"), @Command(value="module <pluginTree> stop"), @Command(value="modules <pluginTree> stop")})
    public void nglbwzmzpsodjaon(CommandClient.Console<?> client, String pluginTree) {
        Flux<Module> flux = CommonCommands.fetchPlugin(client, pluginTree);
        if (flux == null) {
            return;
        }
        if (flux.isEmpty()) {
            client.send(RC.Lang("rustyconnector-pluginAlreadyStopped").generate(new Object[0]));
            return;
        }
        client.send(RC.Lang("rustyconnector-waiting").generate(new Object[0]));
        flux.close();
        try {
            client.send(RC.Lang("rustyconnector-finished").generate(new Object[0]));
        }
        catch (NoSuchElementException e) {
            client.send((Component)Component.text((String)"Successfully stopped that plugin!"));
        }
    }

    @Commands(value={@Command(value="plugin <pluginTree> start"), @Command(value="plugins <pluginTree> start"), @Command(value="module <pluginTree> start"), @Command(value="modules <pluginTree> start")})
    public void asfdmgfsgsodjaon(CommandClient.Console<?> client, String pluginTree) {
        try {
            Flux<Module> flux = CommonCommands.fetchPlugin(client, pluginTree);
            if (flux == null) {
                return;
            }
            if (flux.isPresent()) {
                client.send(RC.Lang("rustyconnector-pluginAlreadyStarted").generate(new Object[0]));
                return;
            }
            client.send(RC.Lang("rustyconnector-waiting").generate(new Object[0]));
            flux.build();
            client.send(RC.Lang("rustyconnector-finished").generate(new Object[0]));
        }
        catch (Exception e) {
            RC.Error(Error.from(e).urgent(true));
        }
    }

    @Nullable
    private static Flux<Module> fetchPlugin(CommandClient.Console<?> client, String pluginTree) {
        String[] nodes = pluginTree.split("\\.");
        AtomicReference<Flux<RCKernel<? extends RCAdapter>>> current = new AtomicReference<Flux<RCKernel<? extends RCAdapter>>>(RustyConnector.Kernel());
        for (int i = 0; i < nodes.length; ++i) {
            boolean isLast;
            String node = nodes[i];
            boolean bl = isLast = i == nodes.length - 1;
            if (!current.get().isPresent()) {
                client.send(Error.withHint("While attempting to fetch the plugin " + pluginTree + " a plugin in the chain was unavailable.", "This issue typically arises when a plugin is being reloaded. In which case wait a bit before attempting to access it.").causedBy("Attempting to fetch the plugin " + pluginTree));
                return null;
            }
            String name = (String)current.get().metadata("name");
            if (name == null) {
                throw new IllegalArgumentException("Fluxes provided to `rustyconnector-details` must contain `name` and `description` metadata.");
            }
            Module module = null;
            try {
                module = current.get().get(3, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!(module instanceof ModuleHolder)) {
                client.send(Error.from(node + " doesn't exist on " + name + ". " + name + " actually doesn't have any children plugins.").causedBy("Attempting to fetch the plugin " + pluginTree));
                return null;
            }
            ModuleHolder moduleHolder = (ModuleHolder)((Object)module);
            Flux newCurrent = moduleHolder.modules().get(node);
            if (newCurrent == null) {
                client.send(Error.withSolution(node + " doesn't exist on " + name + ".", "Available plugins are: " + String.join((CharSequence)(", " + String.valueOf(moduleHolder.modules().keySet())), new CharSequence[0])).causedBy("Attempting to fetch the plugin " + pluginTree));
                return null;
            }
            if (!newCurrent.isPresent() && !isLast) {
                client.send(Error.withHint("Despite existing and being correct; " + node + " is not currently available. It's probably rebooting.", "This issue typically occurs when a plugin is restarting. You can try again after a little bit, or try reloading the plugin directly and see if that works.").causedBy("Attempting to fetch the plugin " + pluginTree));
                return null;
            }
            current.set(newCurrent);
        }
        return current.get();
    }

    @Commands(value={@Command(value="error"), @Command(value="errors")})
    public void nglbwzmxvchdjaon() {
        RC.Adapter().log(Component.join((JoinConfiguration)CommonLang.newlines(), (ComponentLike[])new ComponentLike[]{Component.empty(), RC.Lang().asciiAlphabet().generate("Errors").color((TextColor)NamedTextColor.BLUE), Component.empty(), RC.Errors().fetchAll().isEmpty() ? Component.text((String)"There are no errors to show.", (TextColor)NamedTextColor.DARK_GRAY) : Component.join((JoinConfiguration)CommonLang.newlines(), RC.Errors().fetchAll().stream().map(e -> Component.join((JoinConfiguration)CommonLang.newlines(), (ComponentLike[])new ComponentLike[]{Component.text((String)"------------------------------------------------------", (TextColor)NamedTextColor.DARK_GRAY), e.toComponent()})).toList()), Component.empty()}));
    }

    @Commands(value={@Command(value="error <uuid>"), @Command(value="errors <uuid>")})
    public void nglbwzmxvchdjaon(CommandClient.Console<?> client, String uuid) {
        try {
            UUID errorUUID;
            try {
                errorUUID = UUID.fromString(uuid);
            }
            catch (IllegalArgumentException e) {
                client.send((Component)Component.text((String)"Please provide a valid UUID.", (TextColor)NamedTextColor.BLUE));
                return;
            }
            Error error = RC.Errors().fetch(errorUUID).orElseThrow(() -> new NoSuchElementException("No Error entry exists with the uuid [" + uuid + "]"));
            if (error.throwable() == null) {
                client.send((Component)Component.text((String)("The error [" + uuid + "] doesn't have a throwable to inspect."), (TextColor)NamedTextColor.BLUE));
            }
            RC.Adapter().log(RC.Lang("rustyconnector-exception").generate(error.throwable()));
        }
        catch (Exception e) {
            RC.Error(Error.from(e).urgent(true));
        }
    }

    @Commands(value={@Command(value="packet"), @Command(value="packets")})
    public void yckarhhyoblbmbdl(CommandClient.Console<?> client) {
        try {
            List<Packet> messages = RC.MagicLink().packetCache().packets();
            client.send(RC.Lang("rustyconnector-packets").generate(messages));
        }
        catch (Exception e) {
            RC.Error(Error.from(e).urgent(true));
        }
    }

    @Commands(value={@Command(value="packet clear"), @Command(value="packets clear")})
    public void wuifhmwefmhuidid(CommandClient.Console<?> client) {
        try {
            client.send(RC.Lang("rustyconnector-waiting").generate(new Object[0]));
            RC.MagicLink().packetCache().empty();
            client.send(RC.Lang("rustyconnector-finished").generate(new Object[0]));
        }
        catch (Exception e) {
            RC.Error(Error.from(e).urgent(true));
        }
    }

    @Commands(value={@Command(value="packet <id>"), @Command(value="packets <id>")})
    public void nidbtmkngikxlzyo(CommandClient.Console<?> client, String id) {
        try {
            client.send(RC.Lang("rustyconnector-packetDetails").generate(RC.MagicLink().packetCache().find(NanoID.fromString(id)).orElseThrow(() -> new NoSuchElementException("Unable to find packet with id " + id))));
        }
        catch (Exception e) {
            RC.Error(Error.from(e).urgent(true));
        }
    }

    @Command(value="send")
    public void acmednrmiufxxviz(CommandClient.Console<?> client) {
        client.send(RC.Lang("rustyconnector-sendUsage").generate(new Object[0]));
    }

    @Command(value="send <playerTarget>")
    public void acmednrmiusgxviz(CommandClient.Console<?> client, String playerTarget) {
        this.acmednrmiufxxviz(client);
    }
}

