/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.plugin.common.config;

import group.aelysium.rustyconnector.proxy.util.LiquidTimestamp;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.DeclarativeYAML;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.GitOperator;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.annotations.Comment;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.annotations.Config;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.annotations.Namespace;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.annotations.Node;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.lib.Printer;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

@Namespace(value="rustyconnector")
@Config(value="/gitops.yml")
@Comment(value={"Backs all of the RustyConnector configs behind GitOps so you can sync then to a Git repository.", "If you make changes to this config you must restart RustyConnector to see them."})
public class GitOpsConfig {
    @Node
    private final String repository = "";
    @Node(value=1)
    private final String branch = "main";
    @Node(value=2)
    private final String fetchPeriod = LiquidTimestamp.from(1, TimeUnit.MINUTES).toString();

    public GitOperator.Config config() {
        LiquidTimestamp period = LiquidTimestamp.from(1, TimeUnit.MINUTES);
        try {
            period = LiquidTimestamp.from(this.fetchPeriod);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new GitOperator.Config(URI.create(this.repository)).branch(this.branch).fetchPeriod(period.value(), period.unit()).location(Path.of(DeclarativeYAML.basePath("rustyconnector") + "/git", new String[0]));
    }

    @Nullable
    public static GitOpsConfig New() throws IOException {
        GitOpsConfig config = new GitOpsConfig();
        try {
            DeclarativeYAML.ReadOnly(config, new Printer());
        }
        catch (Exception ignore) {
            return null;
        }
        return config;
    }
}

