/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.plugin.common.config;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.crypt.AES;
import group.aelysium.rustyconnector.common.errors.Error;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.DeclarativeYAML;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.annotations.AllContents;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.annotations.Config;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.annotations.Namespace;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;

@Namespace(value="rustyconnector")
@Config(value="/metadata/aes.private")
public class PrivateKeyConfig {
    @AllContents
    private byte[] key;

    public AES cryptor() {
        return AES.from(Base64.getDecoder().decode(this.key));
    }

    public static PrivateKeyConfig New() throws IOException {
        block8: {
            File file = new File(DeclarativeYAML.basePath("rustyconnector") + "/metadata/aes.private");
            try {
                if (file.exists()) break block8;
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try (FileWriter writer = new FileWriter(file);){
                    writer.write(new String(Base64.getEncoder().encode(AES.createKey()), StandardCharsets.UTF_8));
                }
            }
            catch (Exception e) {
                RC.Error(Error.from(e));
            }
        }
        return DeclarativeYAML.From(PrivateKeyConfig.class);
    }

    public static Optional<PrivateKeyConfig> Load() throws IOException {
        File file = new File(DeclarativeYAML.basePath("rustyconnector") + "/metadata/aes.private");
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                return Optional.empty();
            }
        }
        catch (Exception e) {
            RC.Error(Error.from(e));
        }
        return Optional.of(DeclarativeYAML.From(PrivateKeyConfig.class));
    }
}

