/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.plugin.common.lang;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.errors.Error;
import group.aelysium.rustyconnector.common.lang.Lang;
import group.aelysium.rustyconnector.common.magic_link.packet.Packet;
import group.aelysium.rustyconnector.common.modules.Module;
import group.aelysium.rustyconnector.common.util.Parameter;
import group.aelysium.rustyconnector.proxy.util.Version;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;

public class CommonLang {
    @Lang(value="rustyconnector-finished")
    public static final Component finished = Component.text((String)"Finished!", (TextColor)NamedTextColor.DARK_AQUA);
    @Lang(value="rustyconnector-waiting")
    public static final Component waiting = Component.text((String)"Working on it...", (TextColor)NamedTextColor.BLUE);
    @Lang(value="rustyconnector-unknownCommand")
    public static final String unknownCommand = "Unknown command. Type \"/help\" for help.";
    @Lang(value="rustyconnector-noPermission")
    public static final String noPermission = "You do not have permission to do this.";
    @Lang(value="rustyconnector-internalError")
    public static final String internalError = "There was an internal error while trying to complete that request.";

    public static JoinConfiguration newlines() {
        return JoinConfiguration.separator((ComponentLike)Component.newline());
    }

    @Lang(value="rustyconnector-pluginList")
    public static Component moduleReloadList(Set<String> validModules) {
        return RC.Lang("rustyconnector-box").generate(Component.join((JoinConfiguration)CommonLang.newlines(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Please provide the name of the module you want to see details for. Valid options are:", (TextColor)NamedTextColor.GRAY), Component.text((String)String.join((CharSequence)", ", validModules), (TextColor)NamedTextColor.BLUE), Component.text((String)"If a module has sub-modules, you can view those using using `module.submodule.submodule`.", (TextColor)NamedTextColor.GRAY), Component.space(), Component.text((String)"rc module <target_module>", (TextColor)NamedTextColor.BLUE), Component.text((String)"Returns details for specific modules.", (TextColor)NamedTextColor.DARK_GRAY), Component.space(), Component.text((String)"rc reload <target_module>", (TextColor)NamedTextColor.BLUE), Component.text((String)"Reloads a specific module.", (TextColor)NamedTextColor.DARK_GRAY)}));
    }

    @Lang(value="rustyconnector-formatInstant")
    public static String formatDate(Instant instant) {
        ZoneId zoneId = ZoneId.systemDefault();
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("hh:mma");
        LocalDateTime dateTime = LocalDateTime.ofInstant(instant, zoneId);
        LocalDate date = dateTime.toLocalDate();
        LocalDate today = LocalDate.now(zoneId);
        LocalDate yesterday = today.minusDays(1L);
        String prefix = dateFormatter.format(date);
        if (date.equals(today)) {
            prefix = "Today at";
        }
        if (date.equals(yesterday)) {
            prefix = "Yesterday at";
        }
        String formattedTime = timeFormatter.format(dateTime) + " (" + zoneId.getId() + ")";
        return prefix + " " + formattedTime;
    }

    @Lang(value="rustyconnector-exception")
    public static Component exception(Throwable e) {
        ArrayList<TextComponent> stackTrace = new ArrayList<TextComponent>();
        AtomicReference<Throwable> current = new AtomicReference<Throwable>(e);
        while (current.get() != null) {
            if (current.get().getMessage() != null) {
                stackTrace.add(Component.text((String)current.get().getMessage(), (TextColor)NamedTextColor.AQUA));
            }
            stackTrace.add(Component.text((String)e.getClass().getName(), (TextColor)NamedTextColor.BLUE));
            stackTrace.addAll(Arrays.stream(current.get().getStackTrace()).map(s -> Component.text((String)("        " + s.toString()), (TextColor)NamedTextColor.BLUE)).toList());
            current.set(current.get().getCause());
        }
        return RC.Lang("rustyconnector-box").generate(Component.join((JoinConfiguration)CommonLang.newlines(), stackTrace));
    }

    @Lang(value="rustyconnector-error")
    public static Component error(Error error) {
        try {
            ArrayList<Object> extras = new ArrayList<Object>();
            ZonedDateTime zonedDateTime = error.createdAt().atZone(ZoneId.systemDefault());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String formattedDateTime = zonedDateTime.format(formatter);
            extras.add(Component.join((JoinConfiguration)CommonLang.newlines(), (ComponentLike[])new ComponentLike[]{Component.text((String)"RustyConnector", (TextColor)NamedTextColor.BLUE).append((Component)Component.text((String)(" (" + String.valueOf(error.uuid()) + ") [" + formattedDateTime + "]"), (TextColor)NamedTextColor.DARK_GRAY)), Component.text((String)error.message(), (TextColor)NamedTextColor.GRAY)}));
            TextComponent hintOrSolution = Component.space();
            if (error.hint() != null) {
                hintOrSolution = hintOrSolution.appendNewline().append(Component.text((String)"Hint: ", (TextColor)NamedTextColor.BLUE).append((Component)Component.text((String)error.hint(), (TextColor)NamedTextColor.GRAY)));
            }
            if (error.solution() != null) {
                hintOrSolution = hintOrSolution.appendNewline().append(Component.text((String)"Solution: ", (TextColor)NamedTextColor.BLUE).append((Component)Component.text((String)error.solution(), (TextColor)NamedTextColor.GRAY)));
            }
            extras.add(hintOrSolution);
            if (error.throwable() != null) {
                error.causedBy(error.throwable().getClass().getSimpleName());
            }
            if (!error.details().isEmpty()) {
                extras.add(Component.text((String)"Details: ", (TextColor)NamedTextColor.BLUE));
                extras.add(Component.join((JoinConfiguration)CommonLang.newlines(), error.details().stream().map(e -> (TextComponent)Component.text((String)" \u2022 ", (TextColor)NamedTextColor.DARK_GRAY).append(Component.text((String)(e.key + ": "), (TextColor)NamedTextColor.BLUE).append(CommonLang.typedValue(e.value)))).toList()));
            }
            return Component.join((JoinConfiguration)CommonLang.newlines(), (ComponentLike[])new ComponentLike[]{Component.space(), Component.space(), Component.join((JoinConfiguration)CommonLang.newlines(), extras), Component.space()});
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return Component.space();
        }
    }

    @Lang(value="rustyconnector-bullet")
    public static Component bullet(String value) {
        return Component.text((String)(" \u2022 " + value), (TextColor)NamedTextColor.DARK_GRAY);
    }

    @Lang(value="rustyconnector-keyValue")
    public static Component keyValueLang(String key, Object value) {
        return RC.Lang("rustyconnector-bullet").generate(key + ": ").append(RC.Lang("rustyconnector-typedValue").generate(value));
    }

    public static Component keyValue(String key, Object value) {
        return RC.Lang("rustyconnector-keyValue").generate(key, value);
    }

    @Lang(value="rustyconnector-typedValue")
    public static Component typedValue(Object value) {
        if (value == null) {
            return Component.text((String)"null", (TextColor)NamedTextColor.GRAY);
        }
        Class<?> clazz = value.getClass();
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            return Component.text((String)value.toString(), (TextColor)NamedTextColor.YELLOW);
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return Component.text((String)value.toString(), (TextColor)NamedTextColor.BLUE);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return Component.text((String)("\"" + String.valueOf(value) + "\""), (TextColor)NamedTextColor.GOLD);
        }
        if (Parameter.class.isAssignableFrom(clazz)) {
            return CommonLang.typedValue(((Parameter)value).getOriginalValue());
        }
        if (Component.class.isAssignableFrom(clazz)) {
            return (Component)value;
        }
        return Component.text((String)value.toString(), (TextColor)NamedTextColor.GRAY);
    }

    @Lang(value="rustyconnector-wordmark")
    public static Component wordmark(Version version) {
        TextComponent versionComponent = Component.space();
        if (version != null && !version.equals("")) {
            versionComponent = versionComponent.append((Component)Component.text((String)("Version " + String.valueOf(version)), (TextColor)NamedTextColor.DARK_AQUA));
        }
        return RC.Lang("rustyconnector-box").generate(Component.join((JoinConfiguration)CommonLang.newlines(), (ComponentLike[])new ComponentLike[]{Component.text((String)" /\u2588\u2588\u2588\u2588\u2588\u2588\u2588                        /\u2588\u2588", (TextColor)NamedTextColor.BLUE), Component.text((String)"| \u2588\u2588__  \u2588\u2588                      | \u2588\u2588", (TextColor)NamedTextColor.BLUE), Component.text((String)"| \u2588\u2588  \\ \u2588\u2588 /\u2588\u2588   /\u2588\u2588  /\u2588\u2588\u2588\u2588\u2588\u2588\u2588 /\u2588\u2588\u2588\u2588\u2588\u2588   /\u2588\u2588   /\u2588\u2588", (TextColor)NamedTextColor.BLUE), Component.text((String)"| \u2588\u2588\u2588\u2588\u2588\u2588\u2588/| \u2588\u2588  | \u2588\u2588 /\u2588\u2588_____/|_  \u2588\u2588_/  | \u2588\u2588  | \u2588\u2588", (TextColor)NamedTextColor.BLUE), Component.text((String)"| \u2588\u2588__  \u2588\u2588| \u2588\u2588  | \u2588\u2588|  \u2588\u2588\u2588\u2588\u2588\u2588   | \u2588\u2588    | \u2588\u2588  | \u2588\u2588", (TextColor)NamedTextColor.BLUE), Component.text((String)"| \u2588\u2588  \\ \u2588\u2588| \u2588\u2588  | \u2588\u2588 \\____  \u2588\u2588  | \u2588\u2588 /\u2588\u2588| \u2588\u2588  | \u2588\u2588", (TextColor)NamedTextColor.BLUE), Component.text((String)"| \u2588\u2588  | \u2588\u2588|  \u2588\u2588\u2588\u2588\u2588\u2588/ /\u2588\u2588\u2588\u2588\u2588\u2588\u2588/  |  \u2588\u2588\u2588\u2588/|  \u2588\u2588\u2588\u2588\u2588\u2588\u2588", (TextColor)NamedTextColor.BLUE), Component.text((String)"|__/  |__/ \\______/ |_______/    \\___/   \\____  \u2588\u2588", (TextColor)NamedTextColor.BLUE), Component.text((String)"                                         /\u2588\u2588  | \u2588\u2588  ", (TextColor)NamedTextColor.BLUE).append((Component)versionComponent), Component.text((String)"                                        |  \u2588\u2588\u2588\u2588\u2588\u2588/", (TextColor)NamedTextColor.BLUE), Component.text((String)"  /\u2588\u2588\u2588\u2588\u2588\u2588                                \\______/             /\u2588\u2588", (TextColor)NamedTextColor.BLUE), Component.text((String)" /\u2588\u2588__  \u2588\u2588                                                    | \u2588\u2588", (TextColor)NamedTextColor.BLUE), Component.text((String)"| \u2588\u2588  \\__/  /\u2588\u2588\u2588\u2588\u2588\u2588  /\u2588\u2588\u2588\u2588\u2588\u2588\u2588  /\u2588\u2588\u2588\u2588\u2588\u2588\u2588   /\u2588\u2588\u2588\u2588\u2588\u2588   /\u2588\u2588\u2588\u2588\u2588\u2588\u2588 /\u2588\u2588\u2588\u2588\u2588\u2588    /\u2588\u2588\u2588\u2588\u2588\u2588   /\u2588\u2588\u2588\u2588\u2588\u2588", (TextColor)NamedTextColor.BLUE), Component.text((String)"| \u2588\u2588       /\u2588\u2588__  \u2588\u2588| \u2588\u2588__  \u2588\u2588| \u2588\u2588__  \u2588\u2588 /\u2588\u2588__  \u2588\u2588 /\u2588\u2588_____/|_  \u2588\u2588_/   /\u2588\u2588__  \u2588\u2588 /\u2588\u2588__  \u2588\u2588", (TextColor)NamedTextColor.BLUE), Component.text((String)"| \u2588\u2588      | \u2588\u2588  \\ \u2588\u2588| \u2588\u2588  \\ \u2588\u2588| \u2588\u2588  \\ \u2588\u2588| \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588| \u2588\u2588        | \u2588\u2588    | \u2588\u2588  \\ \u2588\u2588| \u2588\u2588  \\__/", (TextColor)NamedTextColor.BLUE), Component.text((String)"| \u2588\u2588    \u2588\u2588| \u2588\u2588  | \u2588\u2588| \u2588\u2588  | \u2588\u2588| \u2588\u2588  | \u2588\u2588| \u2588\u2588_____/| \u2588\u2588        | \u2588\u2588 /\u2588\u2588| \u2588\u2588  | \u2588\u2588| \u2588\u2588", (TextColor)NamedTextColor.BLUE), Component.text((String)"|  \u2588\u2588\u2588\u2588\u2588\u2588/|  \u2588\u2588\u2588\u2588\u2588\u2588/| \u2588\u2588  | \u2588\u2588| \u2588\u2588  | \u2588\u2588|  \u2588\u2588\u2588\u2588\u2588\u2588\u2588|  \u2588\u2588\u2588\u2588\u2588\u2588\u2588  |  \u2588\u2588\u2588\u2588/|  \u2588\u2588\u2588\u2588\u2588\u2588/| \u2588\u2588", (TextColor)NamedTextColor.BLUE), Component.text((String)" \\______/  \\______/ |__/  |__/|__/  |__/ \\_______/ \\_______/   \\___/   \\______/ |__/", (TextColor)NamedTextColor.BLUE), Component.space(), Component.space(), Component.text((String)"Developed by Aelysium | Juice", (TextColor)NamedTextColor.DARK_AQUA), Component.text((String)"Use: `/rc` to get started", (TextColor)NamedTextColor.DARK_AQUA)}));
    }

    @Lang(value="rustyconnector-box")
    public static Component box(Component component) {
        return Component.join((JoinConfiguration)CommonLang.newlines(), (ComponentLike[])new ComponentLike[]{Component.empty(), Component.empty(), component, Component.empty()});
    }

    @Lang(value="rustyconnector-headerBox")
    public static Component headerBox(@NotNull String header, @NotNull Component content) {
        return RC.Lang("rustyconnector-box").generate(Component.join((JoinConfiguration)CommonLang.newlines(), (ComponentLike[])new ComponentLike[]{RC.Lang().asciiAlphabet().generate(header, NamedTextColor.BLUE), Component.empty(), content}));
    }

    @Lang(value="rustyconnector-packet")
    public static Component message(Packet packet) {
        return Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.empty()), (ComponentLike[])new ComponentLike[]{packet.isLocal() ? Component.text((String)"<<<", (TextColor)NamedTextColor.DARK_BLUE) : Component.text((String)">>>", (TextColor)NamedTextColor.DARK_GREEN), Component.space(), Component.text((String)"[", (TextColor)NamedTextColor.DARK_GRAY), RC.Lang("rustyconnector-formatInstant").generate(packet.created()).color((TextColor)NamedTextColor.YELLOW), Component.text((String)"]", (TextColor)NamedTextColor.DARK_GRAY), Component.text((String)"[", (TextColor)NamedTextColor.DARK_GRAY), Component.text((String)packet.local().replyEndpoint().orElseThrow().toString(), (TextColor)NamedTextColor.GRAY), Component.space(), Component.text((String)packet.type().toString(), (TextColor)NamedTextColor.GRAY), Component.text((String)"]: ", (TextColor)NamedTextColor.DARK_GRAY), packet.successful() ? Component.text((String)"SUCCESS", (TextColor)NamedTextColor.GREEN) : Component.text((String)"ERROR", (TextColor)NamedTextColor.RED)});
    }

    @Lang(value="rustyconnector-packetDetails")
    public static Component messageDetails(Packet packet) {
        String serverDisplayName = null;
        try {
            serverDisplayName = RC.P.Server(packet.local().id()).orElseThrow().displayName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return RC.Lang("rustyconnector-box").generate(Component.join((JoinConfiguration)CommonLang.newlines(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Details:", (TextColor)NamedTextColor.DARK_GRAY), CommonLang.keyValue("ID", packet.local().replyEndpoint().orElseThrow().toString()), CommonLang.keyValue("Type", packet.type().toString()), CommonLang.keyValue("Direction", packet.isLocal() ? "Outgoing" : "Incoming"), CommonLang.keyValue(packet.isLocal() ? "Created" : "Received", RC.Lang("rustyconnector-formatInstant").generate(packet.created())), CommonLang.keyValue("Version", packet.messageVersion()), CommonLang.keyValue("Status", packet.successful() ? Component.text((String)"SUCCESS", (TextColor)NamedTextColor.GREEN) : Component.text((String)"ERROR", (TextColor)NamedTextColor.RED)), CommonLang.keyValue("Reason", packet.statusMessage()), CommonLang.keyValue("Responding To", packet.replying() ? Component.text((String)("Packet " + String.valueOf(packet.remote().replyEndpoint().orElseThrow())), (TextColor)NamedTextColor.DARK_GRAY) : "Nothing"), CommonLang.keyValue("Sender", Component.join((JoinConfiguration)JoinConfiguration.spaces(), (ComponentLike[])new ComponentLike[]{Component.text((String)packet.local().origin().name(), (TextColor)NamedTextColor.DARK_GRAY), Component.text((String)packet.local().id(), (TextColor)NamedTextColor.DARK_GRAY), serverDisplayName == null ? Component.empty() : Component.text((String)("(" + serverDisplayName + ")"), (TextColor)NamedTextColor.DARK_GRAY)})), Component.empty(), Component.text((String)"Properties:", (TextColor)NamedTextColor.DARK_GRAY), Component.join((JoinConfiguration)CommonLang.newlines(), packet.parameters().entrySet().stream().map(e -> CommonLang.keyValue((String)e.getKey(), ((Parameter)e.getValue()).getOriginalValue())).toList()), Component.empty(), Component.text((String)"Raw Packet:", (TextColor)NamedTextColor.DARK_GRAY), Component.text((String)packet.toString(), (TextColor)NamedTextColor.DARK_GRAY)}));
    }

    @Lang(value="rustyconnector-packets")
    public static Component messages(List<Packet> packets) {
        return Component.join((JoinConfiguration)CommonLang.newlines(), (ComponentLike[])new ComponentLike[]{Component.space(), Component.space(), RC.Lang().asciiAlphabet().generate("Packets", NamedTextColor.BLUE), Component.space(), packets.isEmpty() ? Component.text((String)"There are no packets to show.", (TextColor)NamedTextColor.DARK_GRAY) : Component.join((JoinConfiguration)CommonLang.newlines(), packets.stream().map(packet -> RC.Lang("rustyconnector-packet").generate(packet)).toList())});
    }

    @Lang(value="rustyconnector-sendUsage")
    public static Component sendUsage() {
        return RC.Lang("rustyconnector-box").generate(Component.join((JoinConfiguration)CommonLang.newlines(), (ComponentLike[])new ComponentLike[]{Component.text((String)"rc send <username | uuid> <target> [flags]", (TextColor)NamedTextColor.BLUE), Component.text((String)"Sends the user to the specific family!", (TextColor)NamedTextColor.DARK_GRAY), Component.empty(), Component.text((String)"Extra Properties:", (TextColor)NamedTextColor.DARK_GRAY), RC.Lang("rustyconnector-bullet").generate("-f | Marks the target as a family."), RC.Lang("rustyconnector-bullet").generate("-s | Marks the target as a server."), RC.Lang("rustyconnector-bullet").generate("-i | Uses minimal connection power. (Server softCap will be enforced)"), RC.Lang("rustyconnector-bullet").generate("-o | Uses moderate connection power. (Server softCap will be ignored, hardCap will be enforced)"), RC.Lang("rustyconnector-bullet").generate("-a | Uses aggressive connection power. (All caps will be ignored)")}));
    }

    @Lang(value="rustyconnector-noSendTarget")
    public static Component noSendTarget(String target) {
        return Component.text((String)("No server or family exists with the identifier `" + target + "`. Servers must be targeted using the server uuid and families must be targeted using the family id."), (TextColor)NamedTextColor.BLUE);
    }

    @Lang(value="rustyconnector-pluginAlreadyStarted")
    public static Component pluginAlreadyStarted() {
        return Component.text((String)"This plugin is already running!", (TextColor)NamedTextColor.BLUE);
    }

    @Lang(value="rustyconnector-pluginAlreadyStopped")
    public static Component pluginAlreadyStopped() {
        return Component.text((String)"This plugin is already stopped!", (TextColor)NamedTextColor.BLUE);
    }

    @Lang(value="rustyconnector-details")
    public static Component details(String name, String description, Optional<Module> plugin) {
        if (name == null) {
            throw new IllegalArgumentException("`rustyconnector-details` requires that `name` and `description` are not null.");
        }
        if (description == null) {
            throw new IllegalArgumentException("`rustyconnector-details` requires that `name` and `description` are not null.");
        }
        Component details = null;
        try {
            details = plugin.orElseThrow().details();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Component.join((JoinConfiguration)CommonLang.newlines(), (ComponentLike[])new ComponentLike[]{Component.space(), Component.space(), RC.Lang().asciiAlphabet().generate(name, NamedTextColor.BLUE), Component.text((String)description, (TextColor)NamedTextColor.GRAY), Component.space(), plugin.isEmpty() ? Component.text((String)"\u2b24", (TextColor)NamedTextColor.RED).append((Component)Component.text((String)" Stopped", (TextColor)NamedTextColor.GRAY)) : (details == null ? Component.text((String)"There are no other details to show.", (TextColor)NamedTextColor.GRAY) : Component.join((JoinConfiguration)CommonLang.newlines(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Details:", (TextColor)NamedTextColor.DARK_GRAY), details})), Component.space()});
    }
}

