/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.plugin.fabric;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.RustyConnector;
import group.aelysium.rustyconnector.common.RCAdapter;
import group.aelysium.rustyconnector.common.RCKernel;
import group.aelysium.rustyconnector.common.crypt.AES;
import group.aelysium.rustyconnector.common.crypt.NanoID;
import group.aelysium.rustyconnector.common.errors.Error;
import group.aelysium.rustyconnector.common.errors.ErrorRegistry;
import group.aelysium.rustyconnector.common.events.EventManager;
import group.aelysium.rustyconnector.common.haze.HazeProvider;
import group.aelysium.rustyconnector.common.lang.EnglishAlphabet;
import group.aelysium.rustyconnector.common.lang.LangLibrary;
import group.aelysium.rustyconnector.common.magic_link.PacketCache;
import group.aelysium.rustyconnector.common.magic_link.packet.Packet;
import group.aelysium.rustyconnector.common.modules.Module;
import group.aelysium.rustyconnector.common.modules.ModuleLoader;
import group.aelysium.rustyconnector.common.util.CommandClient;
import group.aelysium.rustyconnector.common.util.Parameter;
import group.aelysium.rustyconnector.common.util.URL;
import group.aelysium.rustyconnector.plugin.common.command.CommonCommands;
import group.aelysium.rustyconnector.plugin.common.config.PrivateKeyConfig;
import group.aelysium.rustyconnector.plugin.common.config.ServerIDConfig;
import group.aelysium.rustyconnector.plugin.fabric.FabricClient;
import group.aelysium.rustyconnector.plugin.fabric.FabricServerAdapter;
import group.aelysium.rustyconnector.plugin.serverCommon.CommandRusty;
import group.aelysium.rustyconnector.plugin.serverCommon.DefaultConfig;
import group.aelysium.rustyconnector.plugin.serverCommon.ServerLang;
import group.aelysium.rustyconnector.proxy.util.AddressUtil;
import group.aelysium.rustyconnector.server.ServerKernel;
import group.aelysium.rustyconnector.server.magic_link.WebSocketMagicLink;
import group.aelysium.rustyconnector.shaded.com.google.code.gson.gson.Gson;
import group.aelysium.rustyconnector.shaded.com.google.code.gson.gson.JsonElement;
import group.aelysium.rustyconnector.shaded.com.google.code.gson.gson.JsonObject;
import group.aelysium.rustyconnector.shaded.group.aelysium.ara.Flux;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.DeclarativeYAML;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.annotations.AnnotationParser;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.fabric.FabricServerCommandManager;

public class FabricRustyConnector
implements DedicatedServerModInitializer {
    private final ModuleLoader loader = new ModuleLoader();
    private final Gson gson = new Gson();
    private FabricServerCommandManager<CommandClient> commandManager;

    public void onInitializeServer() {
        DeclarativeYAML.basePath("rustyconnector", "mods/rustyconnector");
        DeclarativeYAML.basePath("rustyconnector-modules", "rc-modules");
        this.commandManager = new FabricServerCommandManager(ExecutionCoordinator.asyncCoordinator(), SenderMapper.create(sender -> {
            if (sender.method_43737()) {
                return new FabricClient.Player((class_2168)sender);
            }
            if (sender.method_9228() == null && sender.method_9211() != null) {
                return new FabricClient.Console((class_2168)sender);
            }
            return new FabricClient.Other((class_2168)sender);
        }, CommandClient::toSender));
        AnnotationParser annotationParser = new AnnotationParser(this.commandManager, CommandClient.class);
        annotationParser.parse(new Object[]{new CommonCommands()});
        annotationParser.parse(new Object[]{new CommandRusty()});
        ServerLifecycleEvents.SERVER_STARTED.register(s -> {
            s.method_43496(class_2561.method_30163((String)"Initializing RustyConnector..."));
            FabricServerAdapter adapter = new FabricServerAdapter(s, (CommandManager<CommandClient>)this.commandManager);
            try {
                if (PrivateKeyConfig.Load().isEmpty()) {
                    ((RCAdapter)adapter).log(Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])new ComponentLike[]{Component.empty(), Component.empty(), Component.empty(), Component.empty(), Component.text((String)"Looks like I'm still waiting on a private.key from the proxy!", (TextColor)NamedTextColor.BLUE), ((TextComponent)Component.text((String)"You'll need to copy ", (TextColor)NamedTextColor.BLUE).append((Component)Component.text((String)"mods/rustyconnector/metadata/aes.private", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)" and paste it into this server in that same folder!", (TextColor)NamedTextColor.BLUE)), Component.text((String)"Both the proxy and I need to have the same aes.private!", (TextColor)NamedTextColor.BLUE), Component.empty(), Component.empty(), Component.empty()}));
                    return;
                }
                RustyConnector.registerAndIgnite(Flux.using(() -> {
                    try {
                        Object id;
                        DefaultConfig config = DefaultConfig.New();
                        if (config.family.isBlank()) {
                            throw new IllegalArgumentException("Please provide a valid family name to target.");
                        }
                        if (config.family.length() > 16) {
                            throw new IllegalArgumentException("Family names are not allowed to be larger than 16 characters.");
                        }
                        ServerIDConfig idConfig = ServerIDConfig.Read();
                        Object object = id = idConfig == null ? null : idConfig.id();
                        if (id == null) {
                            if (config.useUUID) {
                                id = UUID.randomUUID().toString();
                            } else {
                                int extra = 16 - config.family.length();
                                NanoID nanoID = NanoID.randomNanoID(15 + extra);
                                id = config.family + "-" + String.valueOf(nanoID);
                            }
                            ServerIDConfig.Load((String)id);
                        }
                        ServerKernel kernel = new ServerKernel((String)id, new FabricServerAdapter(s, (CommandManager<CommandClient>)this.commandManager), Path.of(DeclarativeYAML.basePath("rustyconnector"), new String[0]), Path.of(DeclarativeYAML.basePath("rustyconnector-modules"), new String[0]), AddressUtil.parseAddress(config.address), config.family);
                        JsonObject metadataJson = this.gson.fromJson(config.metadata, JsonObject.class);
                        metadataJson.entrySet().forEach(e -> kernel.storeMetadata((String)e.getKey(), Parameter.fromJSON((JsonElement)e.getValue())));
                        return kernel;
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                }));
                RustyConnector.Kernel(flux -> {
                    flux.metadata("name", "RCKernel");
                    flux.metadata("description", "The root kernel for RustyConnector where all additional modules build off of.");
                    flux.onStart(kernel -> {
                        this.loader.queue(new ModuleLoader.ModuleRegistrar("LangLibrary", k -> {
                            try {
                                k.registerModule(new Module.Builder<Module>(this, "LangLibrary", "Provides translatable lang messages that can be replaced and repurposed."){

                                    @Override
                                    public Module get() {
                                        LangLibrary l = new LangLibrary(new EnglishAlphabet());
                                        l.registerLangNodes(ServerLang.class);
                                        return l;
                                    }
                                });
                            }
                            catch (Exception e) {
                                RC.Error(Error.from(e));
                            }
                        }, List.of(), List.of("nothingThisIsTheStartOfTheChainIgnoreItYouGoober")));
                        this.loader.queue(new ModuleLoader.ModuleRegistrar("ErrorRegistry", k -> {
                            try {
                                k.registerModule(new Module.Builder<Module>(this, "ErrorRegistry", "Provides error handling services."){

                                    @Override
                                    public Module get() {
                                        return new ErrorRegistry(false, 200);
                                    }
                                });
                            }
                            catch (Exception e) {
                                RC.Error(Error.from(e));
                            }
                        }, List.of("LangLibrary"), List.of()));
                        this.loader.queue(new ModuleLoader.ModuleRegistrar("EventManager", k -> {
                            try {
                                k.registerModule(new Module.Builder<Module>(this, "EventManager", "Provides event handling services."){

                                    @Override
                                    public Module get() {
                                        return new EventManager();
                                    }
                                });
                            }
                            catch (Exception e) {
                                RC.Error(Error.from(e));
                            }
                        }, List.of("ErrorRegistry"), List.of()));
                        this.loader.queue(new ModuleLoader.ModuleRegistrar("MagicLink", k -> {
                            try {
                                k.registerModule(new Module.Builder<Module>(this, "MagicLink", "Provides cross-node packet communication via WebSockets."){

                                    @Override
                                    public Module get() {
                                        try {
                                            DefaultConfig config = DefaultConfig.New();
                                            ServerIDConfig idConfig = ServerIDConfig.Read();
                                            AES aes = PrivateKeyConfig.New().cryptor();
                                            return new WebSocketMagicLink(URL.parseURL(config.magicLink_accessEndpoint), Packet.SourceIdentifier.server(idConfig.id()), aes, new PacketCache(100), null);
                                        }
                                        catch (Exception e) {
                                            RC.Error(Error.from(e).whileAttempting("To initialize MagicLink.").urgent(true));
                                            return null;
                                        }
                                    }
                                });
                            }
                            catch (Exception e) {
                                RC.Error(Error.from(e));
                            }
                        }, List.of("EventManager"), List.of()));
                        this.loader.queue(new ModuleLoader.ModuleRegistrar("Haze", k -> {
                            try {
                                k.registerModule(new Module.Builder<Module>(this, "Haze", "Provides access to remote persistent storage services."){

                                    @Override
                                    public Module get() {
                                        return new HazeProvider();
                                    }
                                });
                            }
                            catch (Exception e) {
                                RC.Error(Error.from(e));
                            }
                        }, List.of("EventManager"), List.of()));
                        this.loader.queueFromFolder("rc-modules");
                        this.loader.resolveAndRegister((RCKernel<?>)kernel);
                    });
                });
                RC.Lang("rustyconnector-wordmark").send(RC.Kernel().version());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(s -> {
            try {
                RustyConnector.unregister();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

