/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.plugin.fabric;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.errors.Error;
import group.aelysium.rustyconnector.common.util.CommandClient;
import group.aelysium.rustyconnector.server.ServerAdapter;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.incendo.cloud.CommandManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FabricServerAdapter
extends ServerAdapter {
    private final MinecraftServer server;
    private final CommandManager<CommandClient> commandManager;

    public FabricServerAdapter(@NotNull MinecraftServer server, @NotNull CommandManager<CommandClient> commandManager) {
        this.server = server;
        this.commandManager = commandManager;
    }

    @Override
    public void setMaxPlayers(int max) {
    }

    @Override
    public int onlinePlayerCount() {
        return this.server.method_3788();
    }

    @Override
    public Optional<String> playerID(@NotNull String username) {
        class_3222 player = this.server.method_3760().method_14566(username);
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of(player.method_5667().toString());
    }

    @Override
    public Optional<String> playerUsername(@NotNull String id) {
        class_3222 player = this.server.method_3760().method_14602(UUID.fromString(id));
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of(player.method_5477().toString());
    }

    @Override
    public boolean isOnline(@NotNull String uuid) {
        class_3222 player = this.server.method_3760().method_14602(UUID.fromString(uuid));
        if (player == null) {
            return false;
        }
        return !player.method_14239();
    }

    @Override
    public void teleport(@NotNull String fromPlayer, @NotNull String toPlayer) {
        try {
            class_3222 player1 = this.server.method_3760().method_14602(UUID.fromString(fromPlayer));
            if (player1 == null) {
                throw new NullPointerException("Player " + fromPlayer + " could not be found.");
            }
            class_3222 player2 = this.server.method_3760().method_14602(UUID.fromString(toPlayer));
            if (player2 == null) {
                throw new NullPointerException("Player " + toPlayer + " could not be found.");
            }
            player2.method_48105(player1.method_51469(), player1.method_23317(), player1.method_23318(), player1.method_23321(), Set.of(), player2.method_36455(), player2.method_36454(), false);
        }
        catch (Exception e) {
            RC.Error(Error.from(e).whileAttempting("To teleport player " + fromPlayer + " to player " + toPlayer));
        }
    }

    @Override
    public void teleport(@NotNull String from, @Nullable String world, @Nullable Double x, @Nullable Double y, @Nullable Double z, @Nullable Float pitch, @Nullable Float yaw) {
        try {
            class_3222 player = this.server.method_3760().method_14602(UUID.fromString(from));
            if (player == null) {
                throw new NullPointerException("Player " + from + " could not be found.");
            }
            player.method_48105(world == null ? player.method_51469() : this.server.method_3847((class_5321)this.server.method_29435().stream().filter(w -> w.method_29177().method_12832().equals(world)).findAny().orElse(null)), x == null ? player.method_23317() : x.doubleValue(), y == null ? player.method_23318() : y.doubleValue(), z == null ? player.method_23321() : z.doubleValue(), Set.of(), pitch == null ? player.method_36455() : pitch.floatValue(), yaw == null ? player.method_36454() : yaw.floatValue(), false);
        }
        catch (Exception e) {
            RC.Error(Error.from(e).whileAttempting("To teleport player " + from + " to " + x + ", " + y + ", " + z + ", (" + pitch + ", " + yaw + ")"));
        }
    }

    @Override
    public void messagePlayer(@NotNull String playerID, @NotNull Component message) {
        try {
            class_3222 player = this.server.method_3760().method_14602(UUID.fromString(playerID));
            if (player == null) {
                return;
            }
            if (player.method_14239()) {
                return;
            }
            player.method_64398((class_2561)class_2561.method_43470((String)LegacyComponentSerializer.legacySection().serialize(message)));
        }
        catch (Exception e) {
            RC.Error(Error.from(e));
        }
    }

    @Override
    public CommandManager<CommandClient> commandManager() {
        return this.commandManager;
    }

    @Override
    public void log(@NotNull Component message) {
        this.server.method_43496((class_2561)class_2561.method_43470((String)LegacyComponentSerializer.legacySection().serialize(message)));
    }
}

