/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.proxy;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.RCAdapter;
import group.aelysium.rustyconnector.common.errors.Error;
import group.aelysium.rustyconnector.proxy.events.FamilyInternalSwitchEvent;
import group.aelysium.rustyconnector.proxy.events.FamilyLeaveEvent;
import group.aelysium.rustyconnector.proxy.events.FamilyPostJoinEvent;
import group.aelysium.rustyconnector.proxy.events.FamilyPreJoinEvent;
import group.aelysium.rustyconnector.proxy.events.FamilySwitchEvent;
import group.aelysium.rustyconnector.proxy.events.NetworkLeaveEvent;
import group.aelysium.rustyconnector.proxy.events.NetworkPostJoinEvent;
import group.aelysium.rustyconnector.proxy.events.NetworkPreJoinEvent;
import group.aelysium.rustyconnector.proxy.events.ServerLeaveEvent;
import group.aelysium.rustyconnector.proxy.events.ServerPostJoinEvent;
import group.aelysium.rustyconnector.proxy.events.ServerPreJoinEvent;
import group.aelysium.rustyconnector.proxy.events.ServerSwitchEvent;
import group.aelysium.rustyconnector.proxy.family.Family;
import group.aelysium.rustyconnector.proxy.family.Server;
import group.aelysium.rustyconnector.proxy.player.Player;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProxyAdapter
extends RCAdapter {
    @NotNull
    public abstract Set<Player> onlinePlayers();

    @Nullable
    public abstract Object convertToObject(@NotNull Player var1);

    @NotNull
    public abstract Player convertToRCPlayer(@NotNull Object var1);

    @NotNull
    public abstract String extractHostname(@NotNull Player var1);

    public abstract boolean registerServer(@NotNull Server var1);

    public abstract void unregisterServer(@NotNull Server var1);

    public abstract boolean serverExists(@NotNull Server var1);

    public abstract Optional<Server> fetchServer(@NotNull Player var1);

    public abstract void disconnect(@NotNull Player var1, @NotNull Component var2);

    public abstract boolean checkPermission(@NotNull Player var1, @NotNull String var2);

    public abstract Player.Connection.Request connectServer(@NotNull Server var1, @NotNull Player var2);

    public final void onServerSwitch(@NotNull Player player, @Nullable Server oldServer, @NotNull Server newServer) throws RuntimeException {
        Family newFamily = newServer.family().orElseThrow();
        if (oldServer == null) {
            RC.P.EventManager().fireEvent(new FamilyPostJoinEvent(newFamily, newServer, player));
            RC.P.EventManager().fireEvent(new ServerPostJoinEvent(newServer, player));
            RC.P.EventManager().fireEvent(new NetworkPostJoinEvent(newFamily, newServer, player));
            return;
        }
        Family oldFamily = oldServer.family().orElseThrow();
        boolean isTheSameFamily = newFamily.equals(oldFamily);
        if (isTheSameFamily) {
            RC.P.EventManager().fireEvent(new FamilyInternalSwitchEvent(newFamily, oldServer, newServer, player));
        } else {
            RC.P.EventManager().fireEvent(new FamilySwitchEvent(oldFamily, newFamily, oldServer, newServer, player));
        }
        RC.P.EventManager().fireEvent(new FamilyLeaveEvent(oldFamily, oldServer, player, false));
        RC.P.EventManager().fireEvent(new FamilyPostJoinEvent(newFamily, newServer, player));
        RC.P.EventManager().fireEvent(new ServerLeaveEvent(oldServer, player, false));
        RC.P.EventManager().fireEvent(new ServerPostJoinEvent(newServer, player));
        RC.P.EventManager().fireEvent(new ServerSwitchEvent(oldServer, newServer, player));
    }

    @NotNull
    public final Player.Connection.Request onInitialConnect(@NotNull Player player, @NotNull Function<Server, Player.Connection.Request> finalizeConnection) throws RuntimeException {
        try {
            RC.P.Players().signedIn(player);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            NetworkPreJoinEvent event = new NetworkPreJoinEvent(player);
            boolean canceled = RC.P.EventManager().fireEvent(event).get(10L, TimeUnit.SECONDS);
            if (canceled) {
                return Player.Connection.Request.failedRequest(player, event.canceledMessage());
            }
        }
        catch (Exception event) {
            // empty catch block
        }
        try {
            Family family = RC.P.Family(RC.P.Families().rootFamily()).orElse(null);
            if (family == null) {
                return Player.Connection.Request.failedRequest(player, "There are no available servers for you to connect to right now.");
            }
            try {
                FamilyPreJoinEvent event = new FamilyPreJoinEvent(family, player, Player.Connection.Power.MINIMAL);
                boolean canceled = RC.P.EventManager().fireEvent(event).get(10L, TimeUnit.SECONDS);
                if (canceled) {
                    return Player.Connection.Request.failedRequest(player, event.canceledMessage());
                }
            }
            catch (Exception event) {
                // empty catch block
            }
            Server server = family.availableServer().orElse(null);
            if (server == null) {
                return Player.Connection.Request.failedRequest(player, "There are no available servers for you to connect to right now.");
            }
            try {
                ServerPreJoinEvent event = new ServerPreJoinEvent(server, player, Player.Connection.Power.MINIMAL);
                boolean canceled = RC.P.EventManager().fireEvent(event).get(10L, TimeUnit.SECONDS);
                if (canceled) {
                    return Player.Connection.Request.failedRequest(player, event.canceledMessage());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return finalizeConnection.apply(server);
        }
        catch (Exception e) {
            RC.Error(Error.from(e));
            return Player.Connection.Request.failedRequest(player, "There was an internal error preventing this connection");
        }
    }

    public final void onDisconnect(@NotNull Player player) {
        try {
            RC.P.Players().signedOut(player);
        }
        catch (Exception exception) {
            // empty catch block
        }
        RC.P.EventManager().fireEvent(new NetworkLeaveEvent(player));
        Server server = player.server().orElse(null);
        if (server == null) {
            return;
        }
        Family family = server.family().orElse(null);
        if (family == null) {
            return;
        }
        RC.P.EventManager().fireEvent(new FamilyLeaveEvent(family, server, player, true));
        RC.P.EventManager().fireEvent(new ServerLeaveEvent(server, player, true));
    }

    @NotNull
    public final PlayerKickedResponse onKicked(@NotNull Player player, @Nullable Component reason) {
        boolean isFromRootFamily = false;
        try {
            Server oldServer = player.server().orElseThrow();
            Family family = oldServer.family().orElseThrow();
            RC.P.EventManager().fireEvent(new FamilyLeaveEvent(family, oldServer, player, true));
            RC.P.EventManager().fireEvent(new ServerLeaveEvent(oldServer, player, true));
            isFromRootFamily = RC.P.Families().rootFamily().equals(oldServer.family());
        }
        catch (Exception oldServer) {
            // empty catch block
        }
        try {
            if (isFromRootFamily) {
                return new PlayerKickedResponse(true, (Component)Objects.requireNonNullElse(reason, Component.text((String)"Kicked by server.")), null);
            }
            Family family = (Family)RC.P.Families().find(RC.P.Families().rootFamily()).get(10, TimeUnit.SECONDS);
            Server server = family.availableServer().orElseThrow();
            return new PlayerKickedResponse(false, reason, server);
        }
        catch (Exception e) {
            RC.Error(Error.from(e).whileAttempting("To catch a player into the root family."));
            return new PlayerKickedResponse(false, (Component)Objects.requireNonNullElse(reason, Component.text((String)"Kicked by server.")), null);
        }
    }

    public record PlayerKickedResponse(boolean shouldDisconnect, @Nullable Component reason, @Nullable Server redirect) {
    }
}

