/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.proxy;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.RCKernel;
import group.aelysium.rustyconnector.proxy.ProxyAdapter;
import group.aelysium.rustyconnector.proxy.events.ServerRegisterEvent;
import group.aelysium.rustyconnector.proxy.events.ServerUnregisterEvent;
import group.aelysium.rustyconnector.proxy.family.Family;
import group.aelysium.rustyconnector.proxy.family.FamilyRegistry;
import group.aelysium.rustyconnector.proxy.family.Server;
import group.aelysium.rustyconnector.shaded.group.aelysium.ara.Flux;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProxyKernel
extends RCKernel<ProxyAdapter> {
    public ProxyKernel(@NotNull String id, @NotNull ProxyAdapter adapter, @NotNull Path directory, @NotNull Path modulesDirectory) throws Exception {
        super(id, adapter, directory, modulesDirectory);
    }

    @NotNull
    public Server registerServer(@NotNull Flux<Family> familyFlux, @NotNull Server.Configuration configuration) throws CancellationException, NoSuchElementException, IllegalStateException {
        Server server;
        FamilyRegistry familyRegistry = RC.P.Families();
        try {
            server = familyRegistry.ServerGenerators().fetch(configuration.metadata().get("serverGenerator").toString()).apply(configuration);
        }
        catch (NullPointerException ignore) {
            server = new Server(configuration.id(), configuration.address(), configuration.metadata(), configuration.timeout());
        }
        Family family = null;
        try {
            family = familyFlux.get(10, TimeUnit.SECONDS);
            try {
                ServerRegisterEvent event = new ServerRegisterEvent(familyFlux.orElseThrow(), configuration);
                boolean canceled = RC.P.EventManager().fireEvent(event).get(1L, TimeUnit.MINUTES);
                if (canceled) {
                    throw new CancellationException(event.canceledMessage());
                }
            }
            catch (Exception event) {
                // empty catch block
            }
            family.addServer(server);
            if (!RC.P.Adapter().registerServer(server)) {
                throw new IllegalStateException("The server failed to register to the proxy software running the RustyConnector kernel.");
            }
        }
        catch (CancellationException | TimeoutException e) {
            if (family != null) {
                family.removeServer(server);
            }
            RC.P.Adapter().unregisterServer(server);
            throw new CancellationException(e.getMessage());
        }
        catch (Exception e) {
            if (family != null) {
                family.removeServer(server);
            }
            RC.P.Adapter().unregisterServer(server);
            throw new IllegalStateException(e);
        }
        return server;
    }

    public void unregisterServer(@NotNull Server server) {
        RC.P.Adapter().unregisterServer(server);
        Family family = server.family().orElse(null);
        if (family != null) {
            family.removeServer(server);
        }
        RC.P.EventManager().fireEvent(new ServerUnregisterEvent(server, family));
    }

    @Override
    @Nullable
    public Component details() {
        int families = RC.P.Families().size();
        int servers = RC.P.Servers().size();
        int players = RC.P.Players().onlinePlayers().size();
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])new ComponentLike[]{RC.Lang("rustyconnector-keyValue").generate("ID", this.id()), RC.Lang("rustyconnector-keyValue").generate("Modules Installed", this.modules.size()), RC.Lang("rustyconnector-keyValue").generate("Family", families), RC.Lang("rustyconnector-keyValue").generate("Servers", servers), RC.Lang("rustyconnector-keyValue").generate("Online Players", players), Component.space(), Component.text((String)"Extra Properties:", (TextColor)NamedTextColor.DARK_GRAY), this.metadata().isEmpty() ? Component.text((String)"There are no properties to show.", (TextColor)NamedTextColor.DARK_GRAY) : Component.join((JoinConfiguration)JoinConfiguration.newlines(), this.metadata().entrySet().stream().map(e -> RC.Lang("rustyconnector-keyValue").generate(e.getKey(), e.getValue())).toList())});
    }
}

