/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.proxy.family;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.modules.Module;
import group.aelysium.rustyconnector.common.modules.ModuleCollection;
import group.aelysium.rustyconnector.common.modules.ModuleHolder;
import group.aelysium.rustyconnector.common.util.MetadataHolder;
import group.aelysium.rustyconnector.proxy.family.Server;
import group.aelysium.rustyconnector.proxy.player.Player;
import group.aelysium.rustyconnector.proxy.util.AddressUtil;
import group.aelysium.rustyconnector.shaded.group.aelysium.ara.Flux;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Family
extends ModuleCollection<Module>
implements MetadataHolder<Object>,
Player.Connectable,
Server.Container,
ModuleHolder<Module>,
Module {
    private final Map<String, Object> metadata = new ConcurrentHashMap<String, Integer>(Map.of("serverSoftCap", 30, "serverHardCap", 40));
    protected final String id;
    protected final String displayName;
    protected final String parent;

    protected Family(@NotNull String id, @Nullable String displayName, @Nullable String parent, @NotNull Map<String, Object> metadata) {
        if (id.length() > 16) {
            throw new IllegalArgumentException("Family names must be no longer than 16 characters. If you want a longer name for the family, use display name.");
        }
        if (id.isBlank()) {
            throw new IllegalArgumentException("Please provide a valid family name.");
        }
        this.id = id;
        this.displayName = displayName;
        this.parent = parent;
        this.metadata.putAll(metadata);
    }

    @Override
    public boolean storeMetadata(String propertyName, Object property) {
        if (this.metadata.containsKey(propertyName)) {
            return false;
        }
        this.metadata.put(propertyName, property);
        return true;
    }

    @Override
    public <T> Optional<T> fetchMetadata(String propertyName) {
        return Optional.ofNullable(this.metadata.get(propertyName));
    }

    @Override
    public void removeMetadata(String propertyName) {
        this.metadata.remove(propertyName);
    }

    @Override
    public Map<String, Object> metadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    @NotNull
    public String id() {
        return this.id;
    }

    @Nullable
    public String displayName() {
        return this.displayName;
    }

    @Override
    public abstract long players();

    @NotNull
    public Optional<Flux<Family>> parent() {
        if (this.parent == null) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(RC.P.Families().find(this.parent));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Family that = (Family)o;
        return Objects.equals(this.id, that.id);
    }

    @Override
    @Nullable
    public Component details() {
        AtomicReference<String> parentName = new AtomicReference<String>("none");
        try {
            Flux parent = this.parent().orElse(null);
            if (parent == null) {
                throw new RuntimeException();
            }
            parent.compute(f -> parentName.set(f.id()), () -> parentName.set("[Unavailable]"), 10, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])new ComponentLike[]{RC.Lang("rustyconnector-keyValue").generate("Display Name", this.displayName() == null ? "No Display Name" : this.displayName()), RC.Lang("rustyconnector-keyValue").generate("Parent Family", parentName.get()), RC.Lang("rustyconnector-keyValue").generate("Servers", this.servers().size()), RC.Lang("rustyconnector-keyValue").generate("Players", this.players()), RC.Lang("rustyconnector-keyValue").generate("Plugins", Component.text((String)String.join((CharSequence)", ", this.modules().keySet()), (TextColor)NamedTextColor.BLUE)), Component.space(), Component.text((String)"Extra Properties:", (TextColor)NamedTextColor.DARK_GRAY), this.metadata().isEmpty() ? Component.text((String)"There are no properties to show.", (TextColor)NamedTextColor.DARK_GRAY) : Component.join((JoinConfiguration)JoinConfiguration.newlines(), this.metadata().entrySet().stream().map(e -> RC.Lang("rustyconnector-keyValue").generate(e.getKey(), e.getValue())).toList()), Component.space(), Component.text((String)"Servers:", (TextColor)NamedTextColor.DARK_GRAY), this.servers().isEmpty() ? Component.text((String)"There are no servers in this family.", (TextColor)NamedTextColor.DARK_GRAY) : Component.join((JoinConfiguration)JoinConfiguration.newlines(), this.servers().stream().map(s -> {
            boolean locked = this.isLocked((Server)s);
            return Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.empty()), (ComponentLike[])new ComponentLike[]{Component.text((String)"[", (TextColor)NamedTextColor.DARK_GRAY), Component.text((String)s.id(), (TextColor)NamedTextColor.BLUE), Component.space(), Component.text((String)AddressUtil.addressToString(s.address()), (TextColor)NamedTextColor.YELLOW), Component.text((String)"]:", (TextColor)NamedTextColor.DARK_GRAY), Component.space(), s.displayName() == null ? Component.empty() : Component.text((String)Objects.requireNonNull(s.displayName()), (TextColor)NamedTextColor.AQUA).append((Component)Component.space()), Component.text((String)"(Players: ", (TextColor)NamedTextColor.DARK_GRAY), Component.text((long)s.players(), (TextColor)NamedTextColor.YELLOW), Component.text((String)")", (TextColor)NamedTextColor.DARK_GRAY), Component.space(), locked ? Component.text((String)"Locked", (TextColor)NamedTextColor.RED) : Component.empty()});
        }).toList())});
    }
}

