/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.proxy.family;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.modules.Module;
import group.aelysium.rustyconnector.common.modules.ModuleCollection;
import group.aelysium.rustyconnector.common.modules.ModuleHolder;
import group.aelysium.rustyconnector.common.util.GeneratorMap;
import group.aelysium.rustyconnector.proxy.events.FamilyRegisterEvent;
import group.aelysium.rustyconnector.proxy.events.FamilyUnregisterEvent;
import group.aelysium.rustyconnector.proxy.family.Family;
import group.aelysium.rustyconnector.proxy.family.Server;
import group.aelysium.rustyconnector.shaded.group.aelysium.ara.Flux;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FamilyRegistry
implements ModuleHolder<Family>,
Module {
    private final ModuleCollection<Family> families = new ModuleCollection();
    private final GeneratorMap<Server.Configuration, Server> serverGenerators = new GeneratorMap();
    private String rootFamily = null;

    public FamilyRegistry() {
        this.serverGenerators.register("default", (K config) -> new Server(config.id(), config.address(), config.metadata(), config.timeout()));
    }

    public GeneratorMap<Server.Configuration, Server> ServerGenerators() {
        return this.serverGenerators;
    }

    public void rootFamily(@NotNull String familyId) {
        this.rootFamily = familyId;
    }

    @NotNull
    public String rootFamily() {
        if (this.rootFamily == null) {
            return "";
        }
        return this.rootFamily;
    }

    public <F extends Family> Flux<F> find(@NotNull String id) {
        return this.families.fetchModule(id);
    }

    public void register(@NotNull String id, @NotNull Module.Builder<Family> tinder) throws Exception {
        Family family = this.families.registerModule(id, tinder);
        try {
            RC.EventManager().fireEvent(new FamilyRegisterEvent(family));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unregister(@NotNull String id) {
        try {
            Family family = (Family)this.families.fetchModule(id).get(3, TimeUnit.SECONDS);
            RC.EventManager().fireEvent(new FamilyUnregisterEvent(family));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.families.unregisterModule(id);
    }

    public int size() {
        return this.families.size();
    }

    @Override
    public void close() throws Exception {
        this.families.close();
    }

    @Override
    public Map<String, Flux<Family>> modules() {
        return this.families.modules();
    }

    @Override
    @Nullable
    public Component details() {
        ArrayList families = new ArrayList();
        this.modules().values().forEach(f -> f.ifPresent(families::add));
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])new ComponentLike[]{RC.Lang("rustyconnector-keyValue").generate("Total Families", this.size()), RC.Lang("rustyconnector-keyValue").generate("Available Families", families.size()), RC.Lang("rustyconnector-keyValue").generate("Root Family", this.rootFamily), Component.space(), Component.text((String)"Registered Families:", (TextColor)NamedTextColor.DARK_GRAY), families.isEmpty() ? Component.text((String)"There are no families registered.", (TextColor)NamedTextColor.DARK_GRAY) : Component.join((JoinConfiguration)JoinConfiguration.newlines(), families.stream().map(f -> Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.empty()), (ComponentLike[])new ComponentLike[]{Component.text((String)"[", (TextColor)NamedTextColor.DARK_GRAY), Component.text((String)f.id(), (TextColor)NamedTextColor.BLUE), Component.text((String)"]:", (TextColor)NamedTextColor.DARK_GRAY), Component.space(), f.displayName() == null ? Component.empty() : Component.text((String)Objects.requireNonNull(f.displayName()), (TextColor)NamedTextColor.AQUA).append((Component)Component.space()), Component.text((String)"(Players: ", (TextColor)NamedTextColor.DARK_GRAY), Component.text((long)f.players(), (TextColor)NamedTextColor.GRAY), Component.text((String)"/", (TextColor)NamedTextColor.DARK_GRAY), f.players() <= (long)f.unlockedServers().stream().map(Server::softPlayerCap).reduce(0, Integer::sum).intValue() ? Component.text((int)f.unlockedServers().stream().map(Server::softPlayerCap).reduce(0, Integer::sum), (TextColor)NamedTextColor.DARK_GRAY) : Component.text((int)f.unlockedServers().stream().map(Server::hardPlayerCap).reduce(0, Integer::sum), (TextColor)NamedTextColor.RED), Component.text((String)")", (TextColor)NamedTextColor.DARK_GRAY), Component.space(), Component.text((String)"(Available Servers: ", (TextColor)NamedTextColor.DARK_GRAY), Component.text((int)f.unlockedServers().size(), (TextColor)NamedTextColor.GRAY), f.lockedServers().isEmpty() ? Component.empty() : Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.empty()), (ComponentLike[])new ComponentLike[]{Component.text((String)"/", (TextColor)NamedTextColor.DARK_GRAY), Component.text((int)f.servers().size(), (TextColor)NamedTextColor.DARK_GRAY)}), Component.text((String)")", (TextColor)NamedTextColor.DARK_GRAY)})).toList())});
    }
}

