/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.proxy.family;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.errors.Error;
import group.aelysium.rustyconnector.common.magic_link.packet.Packet;
import group.aelysium.rustyconnector.common.magic_link.packet.PacketType;
import group.aelysium.rustyconnector.common.util.MetadataHolder;
import group.aelysium.rustyconnector.proxy.Permission;
import group.aelysium.rustyconnector.proxy.events.ServerPreJoinEvent;
import group.aelysium.rustyconnector.proxy.family.Family;
import group.aelysium.rustyconnector.proxy.family.load_balancing.ISortable;
import group.aelysium.rustyconnector.proxy.player.Player;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Server
implements MetadataHolder<Object>,
ISortable,
Player.Connectable {
    private final Map<String, Object> metadata = new ConcurrentHashMap<String, Integer>(Map.of("softCap", 30, "hardCap", 40));
    private final String id;
    private final InetSocketAddress address;
    private final AtomicLong playerCount = new AtomicLong(0L);
    private final AtomicInteger timeout = new AtomicInteger(15);

    public Server(@NotNull String id, @NotNull InetSocketAddress address, @NotNull Map<String, Object> metadata, int timeout) {
        this.id = id;
        this.address = address;
        this.timeout.set(timeout);
        this.metadata.putAll(metadata);
    }

    @Override
    public boolean storeMetadata(String propertyName, Object property) {
        if (this.metadata.containsKey(propertyName)) {
            return false;
        }
        this.metadata.put(propertyName, property);
        return true;
    }

    @Override
    public <T> Optional<T> fetchMetadata(String propertyName) {
        return Optional.ofNullable(this.metadata.get(propertyName));
    }

    @Override
    public void removeMetadata(String propertyName) {
        this.metadata.remove(propertyName);
    }

    @Override
    public Map<String, Object> metadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public boolean stale() {
        return this.timeout.get() <= 0;
    }

    public void setTimeout(int newTimeout) {
        if (newTimeout < 0) {
            throw new IndexOutOfBoundsException("New timeout must be at least 0!");
        }
        this.timeout.set(newTimeout);
    }

    public int decreaseTimeout(int amount) {
        if (amount > 0) {
            amount *= -1;
        }
        int newValue = this.timeout.addAndGet(amount);
        if (this.timeout.get() < 0) {
            this.timeout.set(0);
            return 0;
        }
        return newValue;
    }

    @NotNull
    public String id() {
        return this.id;
    }

    @Nullable
    public String displayName() {
        try {
            return (String)this.metadata.get("displayName");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @NotNull
    public InetSocketAddress address() {
        return this.address;
    }

    public boolean full() {
        return this.playerCount.get() >= (long)this.softPlayerCap();
    }

    public boolean maxed() {
        return this.playerCount.get() >= (long)this.hardPlayerCap();
    }

    public void setPlayerCount(long playerCount) {
        this.playerCount.set(playerCount);
    }

    public int softPlayerCap() {
        return (Integer)Optional.ofNullable(this.metadata.get("softCap")).orElse(30);
    }

    public int hardPlayerCap() {
        return (Integer)Optional.ofNullable(this.metadata.get("hardCap")).orElse(this.softPlayerCap() + 10);
    }

    public boolean registered() {
        if (!RC.P.Adapter().serverExists(this)) {
            return false;
        }
        return !RC.P.Family(this).isEmpty();
    }

    public Optional<Family> family() {
        return RC.P.Family(this);
    }

    public boolean lock() {
        try {
            this.family().orElseThrow().lockServer(this);
            return true;
        }
        catch (Exception e) {
            RC.Error(Error.from(e).whileAttempting("To lock the server " + this.id()));
            return false;
        }
    }

    public boolean unlock() {
        try {
            this.family().orElseThrow().unlockServer(this);
            return true;
        }
        catch (Exception e) {
            RC.Error(Error.from(e).whileAttempting("To unlock the server " + this.id()));
            return false;
        }
    }

    @Override
    public double sortIndex() {
        return this.playerCount.get();
    }

    @Override
    public int weight() {
        try {
            return this.fetchMetadata("loadBalancer-weight").orElse(0);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private boolean validatePlayerLimits(Player player) {
        Family family = this.family().orElseThrow();
        if (Permission.validate(player, "rustyconnector.hardCapBypass", Permission.constructNode("rustyconnector.<family id>.hardCapBypass", family.id()))) {
            return true;
        }
        if (this.maxed()) {
            return false;
        }
        if (Permission.validate(player, "rustyconnector.softCapBypass", Permission.constructNode("rustyconnector.<family id>.softCapBypass", family.id()))) {
            return true;
        }
        return !this.full();
    }

    @Override
    public Player.Connection.Request connect(Player player, Player.Connection.Power power) {
        try {
            if (!player.online()) {
                return Player.Connection.Request.failedRequest(player, player.username() + " isn't online.");
            }
            try {
                ServerPreJoinEvent event = new ServerPreJoinEvent(this, player, power);
                boolean canceled = RC.P.EventManager().fireEvent(event).get(1L, TimeUnit.MINUTES);
                if (canceled) {
                    return Player.Connection.Request.failedRequest(player, event.canceledMessage());
                }
            }
            catch (Exception ignore) {
                return Player.Connection.Request.failedRequest(player, "Connection attempt timed out.");
            }
            if (!this.validatePlayerLimits(player)) {
                return Player.Connection.Request.failedRequest(player, "The server is currently full. Try again later.");
            }
            Player.Connection.Request request = RC.P.Adapter().connectServer(this, player);
            try {
                if (request.result().get(1L, TimeUnit.SECONDS).connected()) {
                    this.playerCount.addAndGet(1L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return request;
        }
        catch (Exception exception) {
            return Player.Connection.Request.failedRequest(player, "Unable to connect you to the server!");
        }
    }

    @Override
    public Player.Connection.Request connect(Player player) {
        return this.connect(player, Player.Connection.Power.MINIMAL);
    }

    @Override
    public long players() {
        return this.playerCount.get();
    }

    public String toString() {
        return "[" + this.displayName() + "](" + String.valueOf(this.address()) + ")";
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Server server = (Server)o;
        return Objects.equals(this.id, server.id());
    }

    public record Configuration(@NotNull String id, @NotNull InetSocketAddress address, @NotNull Map<String, Object> metadata, int timeout) {
    }

    public static interface Packets {

        @PacketType(value="RC-SU")
        public static class Unlock
        extends Packet.Remote {
            public Unlock(Packet packet) {
                super(packet);
            }
        }

        @PacketType(value="RC-SL")
        public static class Lock
        extends Packet.Remote {
            public Lock(Packet packet) {
                super(packet);
            }
        }
    }

    public static interface Container {
        public boolean containsServer(@NotNull String var1);

        public void addServer(@NotNull Server var1);

        public void removeServer(@NotNull Server var1);

        public Optional<Server> fetchServer(@NotNull String var1);

        public List<Server> servers();

        public List<Server> lockedServers();

        public List<Server> unlockedServers();

        public void lockServer(@NotNull Server var1);

        public void unlockServer(@NotNull Server var1);

        public boolean isLocked(@NotNull Server var1);

        public Optional<Server> availableServer();
    }
}

