/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.proxy.family.load_balancing;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.modules.Module;
import group.aelysium.rustyconnector.common.util.MetadataHolder;
import group.aelysium.rustyconnector.proxy.events.FamilyRebalanceEvent;
import group.aelysium.rustyconnector.proxy.events.ServerLockedEvent;
import group.aelysium.rustyconnector.proxy.events.ServerUnlockedEvent;
import group.aelysium.rustyconnector.proxy.family.Server;
import group.aelysium.rustyconnector.proxy.util.LiquidTimestamp;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LoadBalancer
implements Server.Container,
MetadataHolder<Object>,
Module {
    private final Map<String, Object> metadata = new ConcurrentHashMap<String, Object>();
    protected final ScheduledExecutorService executor;
    protected boolean weighted;
    protected boolean persistence;
    protected int attempts;
    protected int index = 0;
    protected Vector<Server> unlockedServers = new Vector();
    protected Vector<Server> lockedServers = new Vector();
    protected Map<String, Server> servers = new ConcurrentHashMap<String, Server>();
    protected Runnable sorter = () -> {
        try {
            Server p = (Server)this.unlockedServers.getFirst();
            if (p == null) {
                p = (Server)this.lockedServers.getFirst();
            }
            RC.P.EventManager().fireEvent(new FamilyRebalanceEvent(p.family().orElseThrow()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.completeSort();
    };

    protected LoadBalancer(boolean weighted, boolean persistence, int attempts, @Nullable LiquidTimestamp rebalance, @NotNull Map<String, Object> metadata) {
        this.weighted = weighted;
        this.persistence = persistence;
        this.attempts = attempts;
        this.metadata.putAll(metadata);
        if (rebalance == null) {
            this.executor = null;
        } else {
            this.executor = Executors.newSingleThreadScheduledExecutor();
            this.executor.schedule(this.sorter, (long)rebalance.value(), rebalance.unit());
        }
    }

    @Override
    public boolean storeMetadata(String propertyName, Object property) {
        if (this.metadata.containsKey(propertyName)) {
            return false;
        }
        this.metadata.put(propertyName, property);
        return true;
    }

    @Override
    public <T> Optional<T> fetchMetadata(String propertyName) {
        return Optional.ofNullable(this.metadata.get(propertyName));
    }

    @Override
    public void removeMetadata(String propertyName) {
        this.metadata.remove(propertyName);
    }

    @Override
    public Map<String, Object> metadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public boolean persistent() {
        return this.persistence;
    }

    public boolean weighted() {
        return this.weighted;
    }

    public int attempts() {
        if (!this.persistent()) {
            return 0;
        }
        return this.attempts;
    }

    public Optional<Server> current() {
        if (this.unlockedServers.isEmpty()) {
            return Optional.empty();
        }
        if (this.index >= this.unlockedServers.size()) {
            this.index = 0;
        }
        return Optional.of(this.unlockedServers.get(this.index));
    }

    public int index() {
        return this.index;
    }

    public void iterate() {
        ++this.index;
        if (this.index >= this.unlockedServers.size()) {
            this.index = 0;
        }
    }

    public final void forceIterate() {
        ++this.index;
        if (this.index >= this.unlockedServers.size()) {
            this.index = 0;
        }
    }

    public abstract void completeSort();

    public abstract void singleSort();

    public void persistence(boolean persistence, int attempts) {
        this.persistence = persistence;
        this.attempts = attempts;
    }

    public void weighted(boolean weighted) {
        this.weighted = weighted;
    }

    public void resetIndex() {
        this.index = 0;
    }

    @Override
    public Optional<Server> availableServer() {
        return this.current();
    }

    @Override
    public void addServer(@NotNull Server server) {
        this.unlockedServers.add(server);
        this.servers.put(server.id(), server);
    }

    @Override
    public void removeServer(@NotNull Server server) {
        if (!this.servers.containsKey(server.id())) {
            return;
        }
        if (!this.unlockedServers.remove(server)) {
            this.lockedServers.remove(server);
        }
        this.servers.remove(server.id());
    }

    @Override
    public Optional<Server> fetchServer(@NotNull String id) {
        return Optional.ofNullable(this.servers.get(id));
    }

    @Override
    public boolean containsServer(@NotNull String id) {
        return this.servers.containsKey(id);
    }

    @Override
    public List<Server> servers() {
        return this.servers.values().stream().toList();
    }

    @Override
    public List<Server> lockedServers() {
        return Collections.unmodifiableList(this.lockedServers);
    }

    @Override
    public List<Server> unlockedServers() {
        return Collections.unmodifiableList(this.unlockedServers);
    }

    @Override
    public void lockServer(@NotNull Server server) {
        try {
            boolean canceled = RC.P.EventManager().fireEvent(new ServerLockedEvent(server.family().orElseThrow(), server)).get(1L, TimeUnit.MINUTES);
            if (canceled) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.unlockedServers.remove(server)) {
            return;
        }
        this.lockedServers.add(server);
    }

    @Override
    public void unlockServer(@NotNull Server server) {
        try {
            boolean canceled = RC.P.EventManager().fireEvent(new ServerUnlockedEvent(server.family().orElseThrow(), server)).get(1L, TimeUnit.MINUTES);
            if (canceled) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.lockedServers.remove(server)) {
            return;
        }
        this.unlockedServers.add(server);
    }

    @Override
    public boolean isLocked(@NotNull Server server) {
        return this.lockedServers.contains(server);
    }

    @Override
    public void close() {
        this.servers.clear();
        this.unlockedServers.clear();
        this.lockedServers.clear();
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Override
    @Nullable
    public Component details() {
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])new ComponentLike[]{RC.Lang("rustyconnector-keyValue").generate("Algorithm", this.getClass().getSimpleName()), RC.Lang("rustyconnector-keyValue").generate("Total Servers", this.servers.size()), RC.Lang("rustyconnector-keyValue").generate("Unlocked Servers", this.unlockedServers.size()), RC.Lang("rustyconnector-keyValue").generate("Locked Servers", this.lockedServers.size()), RC.Lang("rustyconnector-keyValue").generate("Weighted", this.weighted), RC.Lang("rustyconnector-keyValue").generate("Persistence", this.persistence ? "Enabled (" + this.attempts + ")" : "Disabled"), Component.text((String)"Extra Properties:", (TextColor)NamedTextColor.DARK_GRAY), this.metadata().isEmpty() ? Component.text((String)"There are no properties to show.", (TextColor)NamedTextColor.DARK_GRAY) : Component.join((JoinConfiguration)JoinConfiguration.newlines(), this.metadata().entrySet().stream().map(e -> RC.Lang("rustyconnector-keyValue").generate(e.getKey(), e.getValue())).toList())});
    }

    public record Config(@NotNull String name, @NotNull String algorithm, boolean weighted, boolean persistence, int attempts, @Nullable LiquidTimestamp rebalance, @NotNull Map<String, Object> metadata) {
    }
}

