/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.proxy.family.load_balancing;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.modules.Module;
import group.aelysium.rustyconnector.proxy.family.load_balancing.LoadBalancer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadBalancerRegistry
implements Module {
    private final Map<String, Function<LoadBalancer.Config, Module.Builder<LoadBalancer>>> algorithms = new ConcurrentHashMap<String, Function<LoadBalancer.Config, Module.Builder<LoadBalancer>>>();
    private final Function<String, Module.Builder<LoadBalancer>> generator;

    public LoadBalancerRegistry(@NotNull Function<String, Module.Builder<LoadBalancer>> generator) {
        this.generator = generator;
    }

    public Set<String> algorithms() {
        return Collections.unmodifiableSet(this.algorithms.keySet());
    }

    public void register(String algorithm, Function<LoadBalancer.Config, Module.Builder<LoadBalancer>> builder) throws IllegalAccessException {
        if (this.algorithms.containsKey(algorithm.toUpperCase())) {
            throw new IllegalAccessException("Algorithm " + algorithm.toUpperCase() + " already exists!");
        }
        this.algorithms.putIfAbsent(algorithm, builder);
    }

    public void unregister(String algorithm) {
        this.algorithms.remove(algorithm);
    }

    public Function<LoadBalancer.Config, Module.Builder<LoadBalancer>> fetch(String algorithm) {
        return this.algorithms.get(algorithm);
    }

    public void clear() {
        this.algorithms.clear();
    }

    public Module.Builder<LoadBalancer> generate(String name) throws Exception {
        return this.generator.apply(name);
    }

    @Override
    @Nullable
    public Component details() {
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])new ComponentLike[]{RC.Lang("rustyconnector-keyValue").generate("Available Algorithms", String.join((CharSequence)", ", this.algorithms.keySet()))});
    }

    @Override
    public void close() throws Exception {
        this.clear();
    }
}

