/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.proxy.magic_link.packet_handlers;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.magic_link.MagicLinkCore;
import group.aelysium.rustyconnector.common.magic_link.packet.PacketListener;
import group.aelysium.rustyconnector.proxy.family.Family;
import group.aelysium.rustyconnector.proxy.family.Server;
import group.aelysium.rustyconnector.proxy.player.Player;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class SendPlayerListener {
    @PacketListener(value=MagicLinkCore.Packets.SendPlayer.class)
    public PacketListener.Response handle(MagicLinkCore.Packets.SendPlayer packet) throws Exception {
        String serverID;
        Server server;
        String familyID;
        Family family;
        Player.Connection.Result result;
        if (packet.targetFamily().isEmpty() && packet.targetServer().isEmpty() && packet.genericTarget().isEmpty()) {
            throw new IllegalStateException("You must define either a target family or server.");
        }
        if (packet.playerID().isEmpty() && packet.playerUsername().isEmpty()) {
            throw new IllegalStateException("You must define a user to send.");
        }
        Player player = null;
        try {
            if (packet.playerUsername().isPresent()) {
                player = RC.P.PlayerFromUsername(packet.playerUsername().orElseThrow()).orElseThrow();
            }
            if (packet.playerID().isPresent()) {
                player = RC.P.PlayerFromUsername(packet.playerID().orElseThrow()).orElseThrow();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (player == null || !player.online()) {
            throw new NoSuchElementException("No player '" + packet.player() + "' is online.");
        }
        boolean sendFamily = packet.targetFamily().isPresent();
        boolean sendServer = packet.targetServer().isPresent();
        if (packet.genericTarget().isPresent()) {
            String target = packet.genericTarget().orElseThrow();
            Optional<Family> familyOptional = RC.P.Family(target);
            Optional<Server> serverOptional = RC.P.Server(target);
            if (familyOptional.isPresent() && serverOptional.isPresent()) {
                throw new RuntimeException("Both a server and family have the id `" + target + "`. Please clarify if you want to send the player to a family or a server.");
            }
            sendFamily = familyOptional.isPresent();
            sendServer = serverOptional.isPresent();
        }
        Player.Connection.Power power = Player.Connection.Power.MINIMAL;
        List<MagicLinkCore.Packets.SendPlayer.Flag> flags = packet.flags();
        if (flags.contains((Object)MagicLinkCore.Packets.SendPlayer.Flag.MODERATE)) {
            power = Player.Connection.Power.MODERATE;
        }
        if (flags.contains((Object)MagicLinkCore.Packets.SendPlayer.Flag.AGGRESSIVE)) {
            power = Player.Connection.Power.AGGRESSIVE;
        }
        if (sendFamily && !(result = (family = RC.P.Family(familyID = packet.targetFamily().orElseThrow()).orElseThrow(() -> new NoSuchElementException("No family with the id '" + familyID + "' exists."))).connect(player, power).result().get(10L, TimeUnit.SECONDS)).connected()) {
            throw new RuntimeException("Unable to connect the player to that server.");
        }
        if (sendServer && !(result = (server = RC.P.Server(serverID = packet.targetFamily().orElseThrow()).orElseThrow(() -> new NoSuchElementException("No family with the id '" + serverID + "' exists."))).connect(player, power).result().get(10L, TimeUnit.SECONDS)).connected()) {
            throw new RuntimeException("Unable to connect the player to that server.");
        }
        return PacketListener.Response.success("Successfully sent " + player.username() + "!").asReply();
    }
}

