/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.proxy.player;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.proxy.player.Player;
import group.aelysium.rustyconnector.proxy.player.PlayerRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnlinePlayersRegistry
implements PlayerRegistry {
    private final Map<String, Player> playersID = new ConcurrentHashMap<String, Player>();
    private final Map<String, Player> playersUsername = new ConcurrentHashMap<String, Player>();

    public OnlinePlayersRegistry() {
        RC.P.Adapter().onlinePlayers().forEach(p -> {
            this.playersID.put(p.id, (Player)p);
            this.playersUsername.put(p.username, (Player)p);
        });
    }

    @Override
    public void signedIn(@NotNull Player player) {
        this.playersID.put(player.id(), player);
        this.playersUsername.put(player.username(), player);
    }

    @Override
    public void signedOut(@NotNull Player player) {
        this.playersID.remove(player.id());
        this.playersUsername.remove(player.username());
    }

    @Override
    public Optional<Player> fetchByID(@NotNull String id) {
        return Optional.ofNullable(this.playersID.get(id));
    }

    @Override
    public Optional<Player> fetchByUsername(@NotNull String username) {
        return Optional.ofNullable(this.playersUsername.get(username));
    }

    @Override
    @NotNull
    public Set<Player> onlinePlayers() {
        Set<Player> players = RC.P.Adapter().onlinePlayers();
        if (players.size() != this.playersID.size()) {
            players.forEach(p -> {
                this.playersID.put(p.id, (Player)p);
                this.playersUsername.put(p.username, (Player)p);
            });
        }
        return Collections.unmodifiableSet(players);
    }

    @Override
    public void close() {
        this.playersID.clear();
        this.playersUsername.clear();
    }

    @Override
    @Nullable
    public Component details() {
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])new ComponentLike[]{RC.Lang("rustyconnector-keyValue").generate("Total Players", this.playersID.size()), RC.Lang("rustyconnector-keyValue").generate("Players", Component.text((String)String.join((CharSequence)", ", this.playersUsername.keySet().stream().toList()), (TextColor)NamedTextColor.BLUE))});
    }
}

