/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.proxy.player;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.errors.Error;
import group.aelysium.rustyconnector.proxy.family.Family;
import group.aelysium.rustyconnector.proxy.family.Server;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Player {
    protected String id;
    protected String username;

    public Player(@NotNull String id, @NotNull String username) {
        this.id = id;
        this.username = username;
    }

    public String id() {
        return this.id;
    }

    public String username() {
        return this.username;
    }

    public boolean online() {
        return RC.P.Adapter().fetchServer(this).isPresent();
    }

    public void message(@NotNull Component message) {
        try {
            RC.P.Adapter().messagePlayer(this.id(), message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void disconnect(@Nullable Component reason) {
        try {
            RC.P.Adapter().disconnect(this, (Component)(reason == null ? Component.text((String)"Disconnected from server") : reason));
        }
        catch (Exception e) {
            RC.Error(Error.from(e));
        }
    }

    public Optional<Server> server() {
        return RC.P.Adapter().fetchServer(this);
    }

    public Optional<Family> family() {
        try {
            return Optional.of(this.server().orElseThrow().family().orElseThrow());
        }
        catch (Exception ignore) {
            return Optional.empty();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Player that = (Player)object;
        return Objects.equals(this.id, that.id);
    }

    public String toString() {
        return "<Player id=" + this.id + " username=" + this.username + ">";
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public static interface Connection {

        public static enum Power {
            MINIMAL,
            MODERATE,
            AGGRESSIVE;

        }

        public record Result(boolean connected, @NotNull Component message, @Nullable Server server) {
            public static Result failed(@NotNull Component message) {
                return new Result(false, message, null);
            }

            public static Result success(@NotNull Component message, Server server) {
                if (server == null) {
                    return new Result(true, message, null);
                }
                return new Result(true, message, server);
            }
        }

        public record Request(@NotNull Player player, Future<Result> result) {
            public static Request failedRequest(@NotNull Player player, @NotNull Component message) {
                return new Request(player, CompletableFuture.completedFuture(Result.failed(message)));
            }

            public static Request failedRequest(@NotNull Player player, @NotNull String message) {
                return new Request(player, CompletableFuture.completedFuture(Result.failed((Component)Component.text((String)message, (TextColor)NamedTextColor.RED))));
            }

            public static Request successfulRequest(@NotNull Player player, @NotNull Component message, @Nullable Server server) {
                return new Request(player, CompletableFuture.completedFuture(Result.success(message, server)));
            }

            public static Request successfulRequest(@NotNull Player player, @NotNull String message, @Nullable Server server) {
                return new Request(player, CompletableFuture.completedFuture(Result.success((Component)Component.text((String)message, (TextColor)NamedTextColor.GREEN), server)));
            }
        }
    }

    public static interface Connectable {
        public Connection.Request connect(Player var1, Connection.Power var2);

        public Connection.Request connect(Player var1);

        public long players();
    }
}

