/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.proxy.util;

import java.net.InetSocketAddress;
import java.net.URI;
import org.jetbrains.annotations.NotNull;

public final class AddressUtil {
    private static final int DEFAULT_MINECRAFT_PORT = 25565;

    private AddressUtil() {
        throw new AssertionError();
    }

    public static InetSocketAddress parseAddress(@NotNull String ip2) {
        URI uri = URI.create("tcp://" + ip2);
        if (uri.getHost() == null) {
            throw new IllegalStateException("Invalid hostname/IP " + ip2);
        }
        return InetSocketAddress.createUnresolved(uri.getHost(), uri.getPort());
    }

    public static InetSocketAddress parseAndResolveAddress(@NotNull String ip2) {
        URI uri = URI.create("tcp://" + ip2);
        if (uri.getHost() == null) {
            throw new IllegalStateException("Invalid hostname/IP " + ip2);
        }
        int port = uri.getPort() == -1 ? 25565 : uri.getPort();
        return new InetSocketAddress(uri.getHost(), port);
    }

    public static String addressToString(InetSocketAddress address) {
        return address.getHostString() + ":" + address.getPort();
    }
}

