/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.proxy.util;

import java.text.ParseException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class LiquidTimestamp
implements Comparable<LiquidTimestamp> {
    protected TimeUnit unit;
    protected int value;

    private LiquidTimestamp(int value, TimeUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    public static LiquidTimestamp from(String stamp) throws ParseException {
        int value;
        stamp = stamp.toLowerCase();
        try {
            value = Integer.parseInt(stamp.replaceAll("(\\d*).*", "$1"));
        }
        catch (Exception e) {
            throw new ParseException("Unable to parse string. No valid integer value to extract!", 0);
        }
        TimeUnit unit = null;
        try {
            if (stamp.contains("s")) {
                unit = TimeUnit.SECONDS;
            }
            if (stamp.contains("m")) {
                unit = TimeUnit.MINUTES;
            }
            if (stamp.contains("h")) {
                unit = TimeUnit.HOURS;
            }
            if (stamp.contains("d")) {
                unit = TimeUnit.DAYS;
            }
            if (stamp.contains("second")) {
                unit = TimeUnit.SECONDS;
            }
            if (stamp.contains("minute")) {
                unit = TimeUnit.MINUTES;
            }
            if (stamp.contains("hour")) {
                unit = TimeUnit.HOURS;
            }
            if (stamp.contains("day")) {
                unit = TimeUnit.DAYS;
            }
            if (stamp.contains("seconds")) {
                unit = TimeUnit.SECONDS;
            }
            if (stamp.contains("minutes")) {
                unit = TimeUnit.MINUTES;
            }
            if (stamp.contains("hours")) {
                unit = TimeUnit.HOURS;
            }
            if (stamp.contains("days")) {
                unit = TimeUnit.DAYS;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stamp.contains("month")) {
            throw new ParseException("Found `month` being used as a LiquidTimestamp. This is no longer allowed!", 0);
        }
        if (stamp.contains("months")) {
            throw new ParseException("Found `months` being used as a LiquidTimestamp. This is no longer allowed!", 0);
        }
        if (unit == null) {
            throw new ParseException("Unable to parse string. No valid unit to extract!", 0);
        }
        return new LiquidTimestamp(value, unit);
    }

    public TimeUnit unit() {
        return this.unit;
    }

    public ChronoUnit chronoUnit() {
        return switch (this.unit) {
            default -> throw new MatchException(null, null);
            case TimeUnit.DAYS -> ChronoUnit.DAYS;
            case TimeUnit.HOURS -> ChronoUnit.HOURS;
            case TimeUnit.MINUTES -> ChronoUnit.MINUTES;
            case TimeUnit.SECONDS -> ChronoUnit.SECONDS;
            case TimeUnit.MILLISECONDS -> ChronoUnit.MILLIS;
            case TimeUnit.NANOSECONDS -> ChronoUnit.NANOS;
            case TimeUnit.MICROSECONDS -> ChronoUnit.MICROS;
        };
    }

    public int value() {
        return this.value;
    }

    public long epochFromNow() {
        if (this.unit() == null) {
            return 0L;
        }
        long time = Instant.now().getEpochSecond();
        switch (this.unit) {
            case DAYS: {
                time += (long)this.value * 24L * 60L * 60L;
                break;
            }
            case HOURS: {
                time += (long)this.value * 60L * 60L;
                break;
            }
            case MINUTES: {
                time += (long)this.value * 60L;
                break;
            }
            case SECONDS: {
                time += (long)this.value;
            }
        }
        return time;
    }

    public long epochBeforeNow() {
        long time = Instant.now().getEpochSecond();
        switch (this.unit) {
            case DAYS: {
                time -= (long)this.value * 24L * 60L * 60L;
                break;
            }
            case HOURS: {
                time -= (long)this.value * 60L * 60L;
                break;
            }
            case MINUTES: {
                time -= (long)this.value * 60L;
                break;
            }
            case SECONDS: {
                time -= (long)this.value;
            }
        }
        return time;
    }

    public String toString() {
        return this.value + " " + this.unit.toString();
    }

    @Override
    public int compareTo(@NotNull LiquidTimestamp o) {
        return Long.compare(this.epochFromNow(), o.epochFromNow());
    }

    public static LiquidTimestamp from(int value, TimeUnit unit) {
        return new LiquidTimestamp(value, unit);
    }
}

