/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.proxy.util;

import org.jetbrains.annotations.NotNull;

public class Version
implements Comparable<Version> {
    protected int major;
    protected int minor;
    protected int fix;
    protected int build;

    public Version(int major, int minor, int fix) {
        this.major = major;
        this.minor = minor;
        this.fix = fix;
    }

    public Version(String string) throws NumberFormatException {
        String[] stringSplit = string.replace("v", "").split("\\.");
        this.major = Integer.parseInt(stringSplit[0]);
        this.minor = Integer.parseInt(stringSplit[1]);
        this.fix = Integer.parseInt(stringSplit[2]);
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int fix() {
        return this.fix;
    }

    public boolean isGreaterThan(Version anotherVersion) {
        if (this.major() != this.minor()) {
            return this.major() > this.minor();
        }
        if (this.minor() != this.minor()) {
            return this.minor() > this.minor();
        }
        return this.fix() > this.fix();
    }

    public boolean equals(Version anotherVersion) {
        return this.major() == anotherVersion.major() && this.minor() == anotherVersion.minor() && this.fix() == anotherVersion.fix();
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.fix;
    }

    public static Version create(int major, int minor, int fix) {
        return new Version(major, minor, fix);
    }

    public static Version create(String string) {
        return new Version(string);
    }

    @Override
    public int compareTo(@NotNull Version anotherVersion) {
        if (this.major() != anotherVersion.major()) {
            if (this.major > anotherVersion.major()) {
                return 1;
            }
            if (this.major < anotherVersion.major()) {
                return -1;
            }
        }
        if (this.minor != anotherVersion.minor()) {
            if (this.minor > anotherVersion.minor()) {
                return 2;
            }
            if (this.minor < anotherVersion.minor()) {
                return -2;
            }
        }
        if (this.fix != anotherVersion.fix()) {
            if (this.fix > anotherVersion.fix()) {
                return 3;
            }
            if (this.fix < anotherVersion.fix()) {
                return -3;
            }
        }
        return 0;
    }
}

