/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.server;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.errors.Error;
import group.aelysium.rustyconnector.proxy.util.AddressUtil;
import java.net.InetSocketAddress;
import java.util.Optional;

public class Environment {
    public static Optional<String> podName() {
        try {
            return Optional.ofNullable(System.getenv("RC_POD_NAME"));
        }
        catch (Exception e) {
            RC.Error(Error.from(e));
            return Optional.empty();
        }
    }

    public static Optional<InetSocketAddress> address() {
        try {
            String address = System.getenv("RC_ADDRESS");
            if (address == null) {
                return Optional.empty();
            }
            return Optional.of(AddressUtil.parseAddress(address));
        }
        catch (Exception e) {
            RC.Error(Error.from(e));
            return Optional.empty();
        }
    }

    public static Optional<String> displayName() {
        try {
            return Optional.ofNullable(System.getenv("RC_DISPLAY_NAME"));
        }
        catch (Exception e) {
            RC.Error(Error.from(e));
            return Optional.empty();
        }
    }
}

