/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.server;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.RCKernel;
import group.aelysium.rustyconnector.common.magic_link.MagicLinkCore;
import group.aelysium.rustyconnector.common.magic_link.packet.Packet;
import group.aelysium.rustyconnector.common.magic_link.packet.PacketListener;
import group.aelysium.rustyconnector.common.util.Parameter;
import group.aelysium.rustyconnector.proxy.util.AddressUtil;
import group.aelysium.rustyconnector.server.ServerAdapter;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerKernel
extends RCKernel<ServerAdapter> {
    private final String targetFamily;
    private final InetSocketAddress address;

    public ServerKernel(@NotNull String id, @NotNull ServerAdapter adapter, @NotNull Path directory, @NotNull Path modulesDirectory, @NotNull InetSocketAddress address, @NotNull String targetFamily) throws Exception {
        super(id, adapter, directory, modulesDirectory);
        this.address = address;
        this.targetFamily = targetFamily;
        this.storeMetadata("serverGenerator", Parameter.fromUnknown("default"));
    }

    @Nullable
    public String displayName() {
        try {
            return ((Parameter)this.fetchMetadata("displayName").orElseThrow()).toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InetSocketAddress address() {
        return this.address;
    }

    public int playerCount() {
        return ((ServerAdapter)this.Adapter()).onlinePlayerCount();
    }

    @NotNull
    public String targetFamily() {
        return this.targetFamily;
    }

    public CompletableFuture<MagicLinkCore.Packets.Response> lock() {
        CompletableFuture<MagicLinkCore.Packets.Response> response = new CompletableFuture<MagicLinkCore.Packets.Response>();
        Packet.New().identification(Packet.Type.from("RC", "SL")).addressTo(Packet.SourceIdentifier.allAvailableProxies()).send().onReply(MagicLinkCore.Packets.Response.class, packet -> {
            response.complete((MagicLinkCore.Packets.Response)packet);
            return PacketListener.Response.success("Successfully indicated the status of the server's lock request");
        });
        return response;
    }

    public CompletableFuture<MagicLinkCore.Packets.Response> unlock() {
        CompletableFuture<MagicLinkCore.Packets.Response> response = new CompletableFuture<MagicLinkCore.Packets.Response>();
        Packet.New().identification(Packet.Type.from("RC", "SU")).addressTo(Packet.SourceIdentifier.allAvailableProxies()).send().onReply(MagicLinkCore.Packets.Response.class, packet -> {
            response.complete((MagicLinkCore.Packets.Response)packet);
            return PacketListener.Response.success("Successfully indicated the status of the server's unlock request");
        });
        return response;
    }

    public CompletableFuture<MagicLinkCore.Packets.Response> sendID(String playerID, String target, Set<MagicLinkCore.Packets.SendPlayer.Flag> flags) {
        CompletableFuture<MagicLinkCore.Packets.Response> response = new CompletableFuture<MagicLinkCore.Packets.Response>();
        MagicLinkCore.Packets.SendPlayer.sendID(playerID, target, flags).onReply(MagicLinkCore.Packets.Response.class, packet -> {
            response.complete((MagicLinkCore.Packets.Response)packet);
            return PacketListener.Response.success("Successfully indicated the status of the server's send request.");
        });
        return response;
    }

    public CompletableFuture<MagicLinkCore.Packets.Response> sendUsername(String playerUsername, String target, Set<MagicLinkCore.Packets.SendPlayer.Flag> flags) {
        CompletableFuture<MagicLinkCore.Packets.Response> response = new CompletableFuture<MagicLinkCore.Packets.Response>();
        MagicLinkCore.Packets.SendPlayer.sendUsername(playerUsername, target, flags).onReply(MagicLinkCore.Packets.Response.class, packet -> {
            response.complete((MagicLinkCore.Packets.Response)packet);
            return PacketListener.Response.success("Successfully indicated the status of the server's send request.");
        });
        return response;
    }

    @Override
    @Nullable
    public Component details() {
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])new ComponentLike[]{RC.Lang("rustyconnector-keyValue").generate("ID", this.id()), RC.Lang("rustyconnector-keyValue").generate("Modules Installed", this.modules.size()), RC.Lang("rustyconnector-keyValue").generate("Address", AddressUtil.addressToString(this.address())), RC.Lang("rustyconnector-keyValue").generate("Family", this.targetFamily()), RC.Lang("rustyconnector-keyValue").generate("Online Players", this.playerCount()), Component.empty(), Component.text((String)"Extra Properties:", (TextColor)NamedTextColor.DARK_GRAY), this.metadata().isEmpty() ? Component.text((String)"There is no metadata to show.", (TextColor)NamedTextColor.DARK_GRAY) : Component.join((JoinConfiguration)JoinConfiguration.newlines(), this.metadata().entrySet().stream().map(e -> RC.Lang("rustyconnector-keyValue").generate(e.getKey(), e.getValue())).toList())});
    }
}

