/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.server.magic_link;

import group.aelysium.rustyconnector.RC;
import group.aelysium.rustyconnector.common.crypt.AES;
import group.aelysium.rustyconnector.common.errors.Error;
import group.aelysium.rustyconnector.common.magic_link.MagicLinkCore;
import group.aelysium.rustyconnector.common.magic_link.PacketCache;
import group.aelysium.rustyconnector.common.magic_link.packet.Packet;
import group.aelysium.rustyconnector.common.magic_link.packet.PacketListener;
import group.aelysium.rustyconnector.common.util.IPV6Broadcaster;
import group.aelysium.rustyconnector.common.util.Parameter;
import group.aelysium.rustyconnector.common.util.URL;
import group.aelysium.rustyconnector.proxy.util.LiquidTimestamp;
import group.aelysium.rustyconnector.server.ServerKernel;
import group.aelysium.rustyconnector.server.events.ConnectedEvent;
import group.aelysium.rustyconnector.server.events.DisconnectedEvent;
import group.aelysium.rustyconnector.server.magic_link.handlers.HandshakeStalePingListener;
import group.aelysium.rustyconnector.shaded.com.google.code.gson.gson.Gson;
import group.aelysium.rustyconnector.shaded.com.google.code.gson.gson.JsonObject;
import group.aelysium.rustyconnector.shaded.org.java_websocket.Java_WebSocket.client.WebSocketClient;
import group.aelysium.rustyconnector.shaded.org.java_websocket.Java_WebSocket.drafts.Draft_6455;
import group.aelysium.rustyconnector.shaded.org.java_websocket.Java_WebSocket.exceptions.WebsocketNotConnectedException;
import group.aelysium.rustyconnector.shaded.org.java_websocket.Java_WebSocket.handshake.ServerHandshake;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebSocketMagicLink
extends MagicLinkCore.Server {
    protected final ScheduledExecutorService heartbeatExecutor = Executors.newSingleThreadScheduledExecutor();
    protected final ScheduledExecutorService connectionExecutor = Executors.newSingleThreadScheduledExecutor();
    private final LiquidTimestamp retryDelay = LiquidTimestamp.from(10, TimeUnit.SECONDS);
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private final AtomicBoolean connectionClosed = new AtomicBoolean(false);
    private final AtomicBoolean stopHeartbeat = new AtomicBoolean(true);
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private final AtomicReference<WebSocketClient> client = new AtomicReference<Object>(null);
    private final URL address;

    public WebSocketMagicLink(@NotNull URL address, @NotNull Packet.SourceIdentifier self, @NotNull AES aes, @NotNull PacketCache cache, @Nullable IPV6Broadcaster broadcaster) {
        super(self, aes, cache, broadcaster);
        this.address = address.appendPath("bDaBMkmYdZ6r4iFExwW6UzJyNMDseWoS3HDa6FcyM7xNeCmtK98S3Mhp4o7g7oW6VB9CA6GuyH2pNhpQk3QvSmBUeCoUDZ6FXUsFCuVQC59CB2y22SBnGkMf9NMB9UWk");
        this.listen(new HandshakeStalePingListener());
        this.connect();
    }

    public void connect() throws ExceptionInInitializerError {
        if (this.disposed.get()) {
            return;
        }
        if (this.client.get() != null && this.client.get().isOpen()) {
            throw new ExceptionInInitializerError("Unable to connect because there's already a websocket connection active.");
        }
        try {
            String websocketEndpoint;
            CharSequence[] bearer = new String[3];
            try (HttpClient client = HttpClient.newHttpClient();){
                HttpRequest request = HttpRequest.newBuilder().uri(this.address.toURI()).header("Authorization", "Bearer " + this.aes.encrypt(Long.valueOf(Instant.now().getEpochSecond()).toString())).timeout(Duration.of(10L, ChronoUnit.SECONDS)).GET().build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
                if (response.statusCode() == 401) {
                    throw new RuntimeException("The your aes.private is invalid. Make sure the server has the same aes.private as the proxy!");
                }
                if (response.statusCode() != 200) {
                    throw new RuntimeException("Magic Link response: " + response.body());
                }
                Gson gson = new Gson();
                JsonObject object = gson.fromJson(response.body(), JsonObject.class);
                websocketEndpoint = this.aes.decrypt(object.get("endpoint").getAsString());
                bearer[0] = this.aes.decrypt(object.get("token").getAsString());
                bearer[1] = object.get("signature").getAsString();
                bearer[2] = this.self.id();
            }
            Map<String, String> headers = Map.of("Authorization", "Bearer " + this.aes.encrypt(String.join((CharSequence)"$", bearer)), "X-Server-Identification", this.self.toJSON().toString());
            URL websocketURL = this.address.copy();
            if (websocketURL.protocol().equals((Object)URL.Protocol.HTTP)) {
                websocketURL = websocketURL.changeProtocol(URL.Protocol.WS);
            }
            if (websocketURL.protocol().equals((Object)URL.Protocol.HTTPS)) {
                websocketURL = websocketURL.changeProtocol(URL.Protocol.WSS);
            }
            websocketURL = websocketURL.clearPath().appendPath(websocketEndpoint);
            WebSocketClient client = new WebSocketClient(websocketURL.toURI(), new Draft_6455(), headers, 900000){

                @Override
                public void onOpen(ServerHandshake handshake) {
                    WebSocketMagicLink.this.stopHeartbeat.set(false);
                    WebSocketMagicLink.this.connectionClosed.set(false);
                    WebSocketMagicLink.this.heartbeat();
                }

                @Override
                public void onMessage(String message) {
                    WebSocketMagicLink.this.handleMessage(message);
                }

                @Override
                public void onClose(int code, String reason, boolean remote) {
                    if (WebSocketMagicLink.this.connectionClosed.get()) {
                        return;
                    }
                    try {
                        if (code == 1008) {
                            RC.Adapter().log((Component)Component.text((String)("Unable to authenticate with Magic Link to the proxy. Trying again after " + WebSocketMagicLink.this.retryDelay.value() + " " + String.valueOf((Object)WebSocketMagicLink.this.retryDelay.unit()) + ".")));
                        } else {
                            RC.Adapter().log((Component)Component.text((String)("Unable to refresh connection with Magic Link on the proxy. Trying again after " + WebSocketMagicLink.this.retryDelay.value() + " " + String.valueOf((Object)WebSocketMagicLink.this.retryDelay.unit()) + ".")));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    WebSocketMagicLink.this.reset();
                }

                @Override
                public void onError(Exception e) {
                    RC.Error(Error.from(e));
                    if (e instanceof WebsocketNotConnectedException) {
                        WebSocketMagicLink.this.closeConnection();
                    }
                }
            };
            client.setConnectionLostTimeout(0);
            if (client.connectBlocking()) {
                this.client.set(client);
                return;
            }
        }
        catch (Exception e) {
            RC.Error(Error.from(e));
        }
        RC.Adapter().log((Component)Component.text((String)("Unable to refresh connection with Magic Link on the proxy. Trying again after " + this.retryDelay.value() + " " + String.valueOf((Object)this.retryDelay.unit()) + ".")));
        this.reset();
    }

    @Override
    public void publish(Packet.Local packet) {
        try {
            if (this.client.get() == null) {
                return;
            }
            this.cache.cache(packet);
            this.client.get().send(this.aes.encrypt(packet.toString()));
            packet.status(true, "Message successfully delivered.");
        }
        catch (WebsocketNotConnectedException websocketNotConnectedException) {
        }
        catch (Exception e) {
            packet.status(false, e.getMessage());
            RC.Error(Error.from(e));
        }
    }

    public boolean registered() {
        return this.registered.get();
    }

    private void heartbeat() {
        if (this.disposed.get()) {
            return;
        }
        if (this.stopHeartbeat.get()) {
            return;
        }
        Packet.Builder.PrepareForSending packetBuilder = null;
        try {
            ServerKernel kernel = RC.S.Kernel();
            JsonObject metadata = new JsonObject();
            kernel.metadata().forEach((k, v) -> metadata.add((String)k, v.toJSON()));
            packetBuilder = Packet.New().identification(Packet.Type.from("RC", "P")).parameter("tf", kernel.targetFamily()).parameter("a", kernel.address().getHostName() + ":" + kernel.address().getPort()).parameter("m", new Parameter(metadata)).parameter("pc", new Parameter(kernel.playerCount()));
        }
        catch (WebsocketNotConnectedException ignore) {
            return;
        }
        catch (Exception ignore) {
            if (this.disposed.get()) {
                return;
            }
            if (this.stopHeartbeat.get()) {
                return;
            }
            this.heartbeatExecutor.schedule(this::heartbeat, (long)this.delay.get(), TimeUnit.SECONDS);
            return;
        }
        try {
            Packet.Local packet = packetBuilder.addressTo(Packet.SourceIdentifier.allAvailableProxies()).send();
            packet.onReply(MagicLinkCore.Packets.Response.class, p -> {
                if (p.successful()) {
                    boolean canceled = RC.S.EventManager().fireEvent(new ConnectedEvent()).get(1L, TimeUnit.MINUTES);
                    if (canceled) {
                        return PacketListener.Response.canceled();
                    }
                    if (!this.registered.get()) {
                        int interval = p.parameters().get("i").getAsInt();
                        RC.Adapter().log(RC.Lang("rustyconnector-magicLinkHandshake").generate(new Object[0]));
                        this.setDelay(interval);
                        this.registered.set(true);
                    }
                    return PacketListener.Response.success("Successfully informed the server of its registration.");
                }
                RC.S.Adapter().log((Component)Component.text((String)p.message(), (TextColor)NamedTextColor.RED));
                RC.S.Adapter().log((Component)Component.text((String)"Waiting 1 minute before trying again...", (TextColor)NamedTextColor.GRAY));
                this.setDelay(60);
                this.registered.set(false);
                return PacketListener.Response.success("Successfully informed the server of its failure to register.");
            });
        }
        catch (WebsocketNotConnectedException ignore) {
            return;
        }
        catch (Exception e) {
            RC.Error(Error.from(e));
        }
        if (this.disposed.get()) {
            return;
        }
        if (this.stopHeartbeat.get()) {
            return;
        }
        this.heartbeatExecutor.schedule(this::heartbeat, (long)this.delay.get(), TimeUnit.SECONDS);
    }

    public void reset() {
        if (this.disposed.get()) {
            return;
        }
        this.closeConnection();
        this.connectionExecutor.schedule(this::connect, (long)this.retryDelay.value(), this.retryDelay.unit());
    }

    private void closeConnection() {
        this.connectionClosed.set(true);
        this.registered.set(false);
        this.stopHeartbeat.set(true);
        try {
            this.client.get().closeConnection(1000, "Normal closure.");
        }
        catch (Exception e) {
            RC.Error(Error.from(e).whileAttempting("To close the websocket connection used by MagicLink"));
        }
        this.client.set(null);
    }

    @Override
    public void close() {
        this.disposed.set(true);
        try {
            Packet.New().identification(Packet.Type.from("RC", "D")).addressTo(Packet.SourceIdentifier.allAvailableProxies()).send();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closeConnection();
        try {
            RC.S.EventManager().fireEvent(new DisconnectedEvent());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.connectionExecutor.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.heartbeatExecutor.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @Nullable
    public Component details() {
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])new ComponentLike[]{RC.Lang("rustyconnector-keyValue").generate("Target Address", this.address), RC.Lang("rustyconnector-keyValue").generate("Packet Cache Size", this.cache.size()), RC.Lang("rustyconnector-keyValue").generate("Packets Pending Responses", this.packetsAwaitingReply.size()), RC.Lang("rustyconnector-keyValue").generate("Packets Pending Responses", this.packetsAwaitingReply.expiration()), RC.Lang("rustyconnector-keyValue").generate("Ping Delay", this.retryDelay), RC.Lang("rustyconnector-keyValue").generate("Is Registered", this.registered.get()), RC.Lang("rustyconnector-keyValue").generate("Total Listeners Per Packet", Component.text((String)String.join((CharSequence)", ", this.listeners.entrySet().stream().map(e -> (String)e.getKey() + " (" + ((List)e.getValue()).size() + ")").toList())))});
    }
}

