/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.shaded.com.fasterxml.jackson.core.jackson_databind.io.doubleparser;

import group.aelysium.rustyconnector.shaded.com.fasterxml.jackson.core.jackson_databind.io.doubleparser.AbstractJavaFloatingPointBitsFromByteArray;
import group.aelysium.rustyconnector.shaded.com.fasterxml.jackson.core.jackson_databind.io.doubleparser.FastDoubleMath;
import java.nio.charset.StandardCharsets;

final class JavaDoubleBitsFromByteArray
extends AbstractJavaFloatingPointBitsFromByteArray {
    @Override
    long nan() {
        return Double.doubleToRawLongBits(Double.NaN);
    }

    @Override
    long negativeInfinity() {
        return Double.doubleToRawLongBits(Double.NEGATIVE_INFINITY);
    }

    @Override
    long positiveInfinity() {
        return Double.doubleToRawLongBits(Double.POSITIVE_INFINITY);
    }

    @Override
    long valueOfFloatLiteral(byte[] str, int startIndex, int endIndex, boolean isNegative, long significand, int exponent, boolean isSignificandTruncated, int exponentOfTruncatedSignificand) {
        double d = FastDoubleMath.tryDecFloatToDoubleTruncated(isNegative, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand);
        return Double.doubleToRawLongBits(Double.isNaN(d) ? Double.parseDouble(new String(str, startIndex, endIndex - startIndex, StandardCharsets.ISO_8859_1)) : d);
    }

    @Override
    long valueOfHexLiteral(byte[] str, int startIndex, int endIndex, boolean isNegative, long significand, int exponent, boolean isSignificandTruncated, int exponentOfTruncatedSignificand) {
        double d = FastDoubleMath.tryHexFloatToDoubleTruncated(isNegative, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand);
        return Double.doubleToRawLongBits(Double.isNaN(d) ? Double.parseDouble(new String(str, startIndex, endIndex - startIndex, StandardCharsets.ISO_8859_1)) : d);
    }
}

