/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.shaded.group.aelysium.ara;

import group.aelysium.rustyconnector.shaded.group.aelysium.ara.Closure;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Flux<P extends Closure>
implements Closure {
    private final List<Consumer<P>> onStart = new Vector<Consumer<P>>();
    private final List<Runnable> onClose = new Vector<Runnable>();
    private final Map<String, Object> metadata = new ConcurrentHashMap<String, Object>();
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.INACTIVE);
    private final AtomicReference<@NotNull CompletableFuture<P>> resolvable = new AtomicReference(new CompletableFuture());
    private final AtomicReference<@NotNull Supplier<P>> builder;

    protected Flux(@NotNull Supplier<P> builder) {
        this.builder = new AtomicReference<Supplier<P>>(builder);
    }

    public Status status() {
        return this.status.get();
    }

    @NotNull
    public Optional<P> asOptional() {
        CompletableFuture<P> future = this.resolvable.get();
        return Optional.ofNullable(future.getNow(null));
    }

    @Nullable
    public CompletableFuture<P> asFuture() {
        return this.resolvable.get();
    }

    @NotNull
    public P get() throws NullPointerException {
        CompletableFuture<P> future = this.resolvable.get();
        return (P)((Closure)future.getNow(null));
    }

    @NotNull
    public P get(int timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        CompletableFuture<P> future = this.resolvable.get();
        return (P)((Closure)future.get(timeout, unit));
    }

    public void metadata(String key, Object value) {
        this.metadata.put(key, value);
    }

    @Nullable
    public <T> T metadata(String key) throws ClassCastException {
        return (T)this.metadata.get(key);
    }

    @NotNull
    public Map<String, Object> metadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public P orElseThrow() throws NoSuchElementException {
        return (P)((Closure)this.asOptional().orElseThrow());
    }

    public <E extends Throwable> P orElseThrow(Supplier<E> exceptionResolver) throws E {
        return (P)((Closure)this.asOptional().orElseThrow(exceptionResolver));
    }

    public <E extends Throwable> P orElse(@Nullable P other) {
        return (P)((Closure)this.asOptional().orElse(other));
    }

    public boolean isPresent() {
        CompletableFuture<P> future = this.resolvable.get();
        if (future == null) {
            return false;
        }
        if (future.isCancelled()) {
            return false;
        }
        if (future.isCompletedExceptionally()) {
            return false;
        }
        return future.isDone();
    }

    public boolean isEmpty() {
        return !this.isPresent();
    }

    public void ifPresent(@NotNull Consumer<P> ifPresent) {
        this.compute(ifPresent, null, 0, TimeUnit.SECONDS);
    }

    public void ifAbsent(@NotNull Runnable ifEmpty) {
        this.compute(null, ifEmpty, 0, TimeUnit.SECONDS);
    }

    public void compute(@NotNull Consumer<P> ifPresent, @NotNull Runnable ifEmpty) {
        this.compute(ifPresent, ifEmpty, 0, TimeUnit.SECONDS);
    }

    public void compute(@NotNull Consumer<P> ifPresent, int amount, @NotNull TimeUnit unit) {
        this.compute(ifPresent, null, amount, unit);
    }

    public void compute(@Nullable Consumer<P> ifPresent, @Nullable Runnable ifEmpty, int amount, @NotNull TimeUnit unit) {
        if (this.isPresent()) {
            Optional<Object> p = Optional.empty();
            try {
                p = amount == 0 ? Optional.ofNullable(this.resolvable.get().getNow(null)) : Optional.ofNullable((Closure)this.resolvable.get().get(amount, unit));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (p.isPresent()) {
                if (ifPresent == null) {
                    return;
                }
                ifPresent.accept((Closure)p.orElseThrow());
                return;
            }
        }
        if (ifEmpty == null) {
            return;
        }
        ifEmpty.run();
    }

    public void onStart(@NotNull Consumer<P> consumer) {
        this.onStart.add(consumer);
        if (this.isPresent()) {
            consumer.accept(this.orElseThrow());
        }
    }

    public void onClose(@NotNull Runnable runnable) {
        this.onClose.add(runnable);
        if (this.isEmpty()) {
            runnable.run();
        }
    }

    private void build(@NotNull Supplier<P> builder) throws InterruptedException {
        if (this.isPresent()) {
            throw new InterruptedException("You must close the already running Particle before building a new one.");
        }
        CompletableFuture<Closure> future = new CompletableFuture<Closure>();
        this.resolvable.set(future);
        this.status.set(Status.STARTING);
        Closure p = (Closure)builder.get();
        if (p == null) {
            future.completeExceptionally(new RuntimeException("Particle failed to build."));
            this.status.set(Status.FAILED_BUILD);
            return;
        }
        this.status.set(Status.ACTIVE);
        future.complete(p);
        try {
            this.handleStart(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void build() throws InterruptedException {
        this.build(this.builder.get());
    }

    public void rebuild() throws Exception {
        this.close();
        this.build();
    }

    public boolean rebuild(@NotNull Supplier<P> newBuilder, boolean rollback) throws Exception {
        this.close();
        try {
            this.build(newBuilder);
            this.orElseThrow();
            this.builder.set(newBuilder);
            return true;
        }
        catch (Exception ignore) {
            this.close();
            if (!rollback) {
                return false;
            }
            this.build();
            return true;
        }
    }

    @Override
    public void close() {
        try {
            this.status.set(Status.INACTIVE);
            CompletableFuture<P> future = this.resolvable.get();
            if (future.isDone()) {
                try {
                    ((Closure)future.getNow(null)).close();
                }
                catch (Exception exception) {}
            } else {
                future.completeExceptionally(new InterruptedException("Particle boot was interrupted by its Flux closing!"));
            }
            this.resolvable.set(new CompletableFuture());
            this.handleClose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleStart(P particle) {
        this.onStart.forEach(c -> {
            try {
                c.accept(particle);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void handleClose() {
        this.onClose.forEach(r -> {
            try {
                r.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @NotNull
    public static <T extends Closure> Flux<T> using(@NotNull Supplier<T> builder) {
        return new Flux<T>(builder);
    }

    public static enum Status {
        ACTIVE,
        STARTING,
        INACTIVE,
        FAILED_BUILD;

    }
}

