/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml;

import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.GitOperator;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.InitializationPhase;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.InjectionPhase;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.LoadingPhase;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.annotations.Config;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.lib.Printer;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.lib.YAMLNode;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.CommentedConfigurationNode;

public class DeclarativeYAML {
    private static final Map<String, GitOperator> operators = new ConcurrentHashMap<String, GitOperator>();
    private static final Map<String, String> basePaths = new ConcurrentHashMap<String, String>();

    public static void registerRepository(String namespace, GitOperator.Config config) {
        if (operators.containsKey(namespace)) {
            throw new RuntimeException("The namespace " + namespace + " is already being used.");
        }
        operators.put(namespace, config.build());
    }

    public static Optional<GitOperator> fetchRepository(@NotNull String namespace) {
        return Optional.ofNullable(operators.get(namespace));
    }

    public static void basePath(String namespace, String basePath) {
        if (!Pattern.compile("^[a-zA-Z0-9\\_\\-\\.\\/\\\\]+$").matcher(basePath).matches()) {
            throw new IllegalArgumentException("Invalid base path string: " + basePath);
        }
        basePaths.put(namespace, basePath);
    }

    public static String basePath(String namespace) {
        return Optional.ofNullable(basePaths.get(namespace)).orElse("");
    }

    public static <T> T From(@NotNull Class<T> clazz, @NotNull Printer printer) throws RuntimeException {
        try {
            if (!clazz.isAnnotationPresent(Config.class)) {
                throw new RuntimeException("Config class declarations must be annotated with @Config.");
            }
            T instance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            YAMLNode node = InitializationPhase.nodesFromClass(instance, printer);
            CommentedConfigurationNode yaml = LoadingPhase.loadYAMLFile(instance, printer, node);
            InjectionPhase.injectConfigValueIntoClass(instance, printer, yaml);
            return instance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T From(@NotNull Class<T> clazz) throws RuntimeException {
        return DeclarativeYAML.From(clazz, new Printer());
    }

    @Contract(mutates="param1")
    public static void ReadOnly(@NotNull Object instance, @NotNull Printer printer) {
        try {
            if (!instance.getClass().isAnnotationPresent(Config.class)) {
                throw new RuntimeException("Config class declarations must be annotated with @Config.");
            }
            CommentedConfigurationNode yaml = LoadingPhase.reloadYAMLFile(instance, printer);
            InjectionPhase.injectConfigValueIntoClass(instance, printer, yaml);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void WriteOnly(@NotNull Object instance, @NotNull Printer printer) {
        try {
            if (!instance.getClass().isAnnotationPresent(Config.class)) {
                throw new RuntimeException("Config class declarations must be annotated with @Config.");
            }
            YAMLNode node = InitializationPhase.nodesFromClass(instance, printer);
            LoadingPhase.updateYAMLFile(instance, printer, node);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

