/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml;

import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.InjectionPhase;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.annotations.Node;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.lib.Primitives;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.lib.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.CommentedConfigurationNode;

class Deserializer {
    public static final String supportedMaps = String.join((CharSequence)", ", List.of("Map<String, Primitive>", "Map<String, String>", "Map<String, Serializable>", "Map<String, Enum>", "Map<String, Record>"));
    public static final String supportedTypes = String.join((CharSequence)", ", List.of("Primitive", "String", "Serializable", "Enums", "Java Records", "List<Primitive>", "List<String>", "List<Serializable", "List<Enum>", "List<Record>", "Set<Primitive>", "Set<String>", "Set<Serializable>", "Set<Enum>", "Set<Record>", supportedMaps));

    Deserializer() {
    }

    @NotNull
    public static Object deserialize(CommentedConfigurationNode node, Class<?> clazz, Type type) throws Exception {
        if (Primitives.isPrimitive(clazz)) {
            return Deserializer.serializePrimitive(node, clazz);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return Deserializer.serializeString(node);
        }
        if (Serializable.class.isAssignableFrom(clazz)) {
            return Deserializer.serializeObject(node, clazz);
        }
        if (clazz.isEnum()) {
            Class<?> enumType = clazz;
            return Deserializer.serializeEnum(node, enumType);
        }
        if (Record.class.isAssignableFrom(clazz)) {
            return Deserializer.serializeRecord(node, clazz);
        }
        if (!(type instanceof ParameterizedType)) {
            throw new RuntimeException(clazz.getSimpleName() + " is not a type that's supported by Declarative YAML. Supported types are: " + supportedTypes);
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (List.class.isAssignableFrom(clazz)) {
            return Deserializer.serializeList(node, clazz, parameterizedType);
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return Deserializer.serializeSet(node, clazz, parameterizedType);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return Deserializer.serializeMap(node, clazz, parameterizedType);
        }
        throw new RuntimeException(clazz.getSimpleName() + " is not a type that's supported by Declarative YAML. Supported types are: " + supportedTypes);
    }

    private static Object serializePrimitive(CommentedConfigurationNode node, Class<?> clazz) throws Exception {
        if (clazz.isAssignableFrom(Boolean.TYPE)) {
            return node.getBoolean();
        }
        if (clazz.isAssignableFrom(Integer.TYPE)) {
            return node.getInt();
        }
        if (clazz.isAssignableFrom(Long.TYPE)) {
            return node.getLong();
        }
        if (clazz.isAssignableFrom(Float.TYPE)) {
            return Float.valueOf(node.getFloat());
        }
        if (clazz.isAssignableFrom(Double.TYPE)) {
            return node.getDouble();
        }
        return node.get(clazz);
    }

    private static String serializeString(CommentedConfigurationNode node) {
        return node.getString();
    }

    private static Object serializeObject(CommentedConfigurationNode objectRoot, Class<?> clazz) throws Exception {
        try {
            List<Field> fields = Arrays.stream(clazz.getFields()).filter(f -> Modifier.isFinal(f.getModifiers()) && f.isAnnotationPresent(Node.class)).toList();
            clazz.getConstructor(new Class[0]).setAccessible(true);
            Object instance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            clazz.getConstructor(new Class[0]).setAccessible(false);
            for (Field f2 : fields) {
                boolean isOptional = f2.isAnnotationPresent(Nullable.class);
                f2.setAccessible(true);
                try {
                    String key = Deserializer.convertFieldNameToYAMLKey(f2);
                    CommentedConfigurationNode node = InjectionPhase.getNodeFromYAML(objectRoot, key);
                    f2.set(instance, Deserializer.deserialize(node, f2.getType(), f2.getGenericType()));
                }
                catch (Exception e) {
                    if (isOptional) {
                        f2.set(instance, null);
                        f2.setAccessible(false);
                        continue;
                    }
                    f2.setAccessible(false);
                    throw e;
                }
                f2.setAccessible(false);
            }
            return instance;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private static Object serializeEnum(CommentedConfigurationNode node, Class<? extends Enum<?>> clazz) {
        String value = node.getString();
        if (value == null || value.isBlank()) {
            throw new IllegalArgumentException("Enum value is missing for " + clazz.getSimpleName());
        }
        try {
            return Enum.valueOf(clazz.asSubclass(Enum.class), value.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid enum value '" + value + "' for enum " + clazz.getSimpleName() + ". Supported values are: " + Arrays.toString(clazz.getEnumConstants()), e);
        }
    }

    private static Object serializeRecord(CommentedConfigurationNode node, Class<?> clazz) throws Exception {
        RecordComponent[] components = clazz.getRecordComponents();
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (RecordComponent component2 : components) {
            String key = Deserializer.convertFieldNameToYAMLKey(component2.getName());
            CommentedConfigurationNode componentNode = (CommentedConfigurationNode)node.node(new Object[]{key});
            values.put(component2.getName(), Deserializer.deserialize(componentNode, component2.getType(), component2.getGenericType()));
        }
        Object[] valuesArray = Arrays.stream(components).map(component -> values.get(component.getName())).toArray();
        Constructor<?> constructor = clazz.getDeclaredConstructor((Class[])Arrays.stream(components).map(RecordComponent::getType).toArray(Class[]::new));
        constructor.setAccessible(true);
        Object instance = constructor.newInstance(valuesArray);
        constructor.setAccessible(false);
        return instance;
    }

    private static List<Object> serializeList(CommentedConfigurationNode node, Class<?> clazz, ParameterizedType type) throws Exception {
        Type entryType = type.getActualTypeArguments()[0];
        Class entryClass = (Class)type.getActualTypeArguments()[0];
        if (!(Primitives.isPrimitive(entryClass) || String.class.isAssignableFrom(entryClass) || Serializable.class.isAssignableFrom(entryClass))) {
            throw new ClassCastException(clazz.getSimpleName() + " isn't a supported type in Declarative YAML. The supported types are: " + supportedTypes);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (CommentedConfigurationNode entry : node.childrenList()) {
            list.add(Deserializer.deserialize(entry, entryClass, entryType));
        }
        return Collections.unmodifiableList(list);
    }

    private static Set<Object> serializeSet(CommentedConfigurationNode node, Class<?> clazz, ParameterizedType type) throws Exception {
        Type entryType = type.getActualTypeArguments()[0];
        Class entryClass = (Class)type.getActualTypeArguments()[0];
        if (!(Primitives.isPrimitive(entryClass) || String.class.isAssignableFrom(entryClass) || Serializable.class.isAssignableFrom(entryClass))) {
            throw new ClassCastException(clazz.getSimpleName() + " isn't a supported type in Declarative YAML. The supported types are: " + supportedTypes);
        }
        HashSet<Object> set = new HashSet<Object>();
        for (CommentedConfigurationNode entry : node.childrenList()) {
            set.add(Deserializer.deserialize(entry, entryClass, entryType));
        }
        return Collections.unmodifiableSet(set);
    }

    private static Map<String, ?> serializeMap(CommentedConfigurationNode node, Class<?> clazz, ParameterizedType type) throws Exception {
        Type keyType = type.getActualTypeArguments()[0];
        Type valueType = type.getActualTypeArguments()[1];
        Class keyClass = (Class)type.getActualTypeArguments()[0];
        Class valueClass = (Class)type.getActualTypeArguments()[1];
        if (!String.class.isAssignableFrom(keyClass)) {
            throw new ClassCastException(clazz.getSimpleName() + " isn't a supported type in Declarative YAML. The supported types are: " + supportedTypes);
        }
        if (!(Primitives.isPrimitive(valueClass) || String.class.isAssignableFrom(valueClass) || Serializable.class.isAssignableFrom(valueClass))) {
            throw new ClassCastException(clazz.getSimpleName() + " isn't a supported type in Declarative YAML. The supported types are: " + supportedTypes);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : node.childrenMap().entrySet()) {
            Object k = entry.getKey();
            if (!(k instanceof String)) {
                throw new IllegalArgumentException("Declarative YAML requires that maps loaded from YAML must be of the type [" + supportedMaps + "].");
            }
            String key = (String)k;
            map.put(key, Deserializer.deserialize((CommentedConfigurationNode)entry.getValue(), valueClass, valueType));
        }
        return Collections.unmodifiableMap(map);
    }

    public static String convertFieldNameToYAMLKey(String name) {
        return String.join((CharSequence)".", Arrays.stream(name.split("_")).map(s -> s.replaceAll("([a-z])([A-Z]+)", "$1-$2").toLowerCase()).toList());
    }

    public static String convertFieldNameToYAMLKey(Field field) {
        return Deserializer.convertFieldNameToYAMLKey(field.getName());
    }
}

