/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml;

import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.ConfigTarget;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.Deserializer;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.annotations.Comment;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.annotations.Node;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.lib.Printer;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.lib.YAMLNode;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

class InitializationPhase {
    InitializationPhase() {
    }

    public static YAMLNode nodesFromClass(Object instance, Printer printer) {
        List<ConfigTarget> targets = InitializationPhase.generateConfigTargets(instance, printer);
        return InitializationPhase.convertConfigTargetsToYAMLNodes(instance.getClass(), targets);
    }

    public static List<ConfigTarget> generateConfigTargets(@NotNull Object instance, Printer printer) {
        Vector<ConfigTarget> targets = new Vector<ConfigTarget>();
        Arrays.stream(instance.getClass().getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).toList().forEach(f -> {
            String key;
            if (!f.isAnnotationPresent(Node.class)) {
                return;
            }
            Node node = f.getAnnotation(Node.class);
            ArrayList<String> comment = null;
            if (f.isAnnotationPresent(Comment.class)) {
                Comment c = f.getAnnotation(Comment.class);
                comment = new ArrayList<String>();
                for (String s : c.value()) {
                    AtomicReference<String> correctedString = new AtomicReference<String>(s);
                    printer.commentReplacements().forEach((k, v) -> correctedString.set(((String)correctedString.get()).replace("{" + k + "}", (CharSequence)v)));
                    comment.add(correctedString.get());
                }
            }
            if ((key = node.key()).isEmpty()) {
                key = Deserializer.convertFieldNameToYAMLKey(f);
            }
            Object defaultValue = null;
            try {
                f.setAccessible(true);
                defaultValue = f.get(instance);
                f.setAccessible(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (defaultValue == null) {
                throw new NullPointerException("You must define a default value on fields annotated with @Node. Issue was caused by " + f.getName());
            }
            targets.add(new ConfigTarget(node.value(), key, defaultValue, (Field)f, (List<String>)comment));
        });
        targets.sort((target1, target2) -> {
            int compare = Integer.compare(target1.order(), target2.order());
            if (compare == 0) {
                return target1.key().compareTo(target2.key());
            }
            return compare;
        });
        return targets;
    }

    private static YAMLNode convertConfigTargetsToYAMLNodes(@NotNull Class<?> clazz, List<ConfigTarget> targets) {
        YAMLNode root;
        try {
            Comment comment = clazz.getAnnotation(Comment.class);
            root = new YAMLNode(null, Arrays.asList(comment.value()));
        }
        catch (Exception ignore) {
            root = new YAMLNode(null, null);
        }
        for (ConfigTarget parsingTarget : targets) {
            String[] keys = parsingTarget.key().split("\\.");
            AtomicReference<YAMLNode> currentNode = new AtomicReference<YAMLNode>(root);
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                boolean lastKey = i == keys.length - 1;
                YAMLNode newCurrent = currentNode.get().setGetChild(key, lastKey ? new YAMLNode(key, parsingTarget.value(), parsingTarget.comment()) : new YAMLNode(key, null));
                if (Set.class.isAssignableFrom(parsingTarget.value().getClass())) {
                    newCurrent.isArray(true);
                }
                if (List.class.isAssignableFrom(parsingTarget.value().getClass())) {
                    newCurrent.isArray(true);
                }
                currentNode.set(newCurrent);
            }
        }
        return root;
    }
}

