/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml;

import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.ConfigTarget;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.Deserializer;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.InitializationPhase;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.LoadingPhase;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.annotations.AllContents;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.annotations.PathParameter;
import group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.lib.Printer;
import java.io.File;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.CommentedConfigurationNode;

class InjectionPhase {
    InjectionPhase() {
    }

    public static void injectConfigValueIntoClass(@NotNull Object instance, Printer printer, CommentedConfigurationNode yaml) throws Exception {
        InjectionPhase.pathParameters(instance, printer);
        InjectionPhase.handleAllContents(instance, LoadingPhase.resolveFile(instance, printer));
        for (ConfigTarget target : InitializationPhase.generateConfigTargets(instance, printer)) {
            if (target.field() == null) continue;
            target.field().setAccessible(true);
            target.field().set(instance, InjectionPhase.getValueFromYAML(yaml, target));
            target.field().setAccessible(false);
        }
    }

    private static void pathParameters(@NotNull Object instance, @NotNull Printer printer) {
        Arrays.stream(instance.getClass().getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).toList().forEach(f -> {
            if (!f.isAnnotationPresent(PathParameter.class)) {
                return;
            }
            PathParameter pathParameter = f.getAnnotation(PathParameter.class);
            try {
                f.setAccessible(true);
                f.set(instance, printer.pathReplacements().get(pathParameter.value()));
                f.setAccessible(false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static Object getValueFromYAML(CommentedConfigurationNode root, ConfigTarget target) throws Exception {
        CommentedConfigurationNode node = InjectionPhase.getNodeFromYAML(root, target.key());
        return Deserializer.deserialize(node, target.field().getType(), target.field().getGenericType());
    }

    public static CommentedConfigurationNode getNodeFromYAML(CommentedConfigurationNode node, String route) throws Exception {
        String[] steps = route.split("\\.");
        AtomicReference<CommentedConfigurationNode> currentNode = new AtomicReference<CommentedConfigurationNode>(node);
        Arrays.stream(steps).forEach(step -> currentNode.set((CommentedConfigurationNode)((CommentedConfigurationNode)currentNode.get()).node(new Object[]{step})));
        if (currentNode.get() == null) {
            throw new NullPointerException("The node " + route + " is null.");
        }
        return currentNode.get();
    }

    private static void handleAllContents(@NotNull Object instance, @NotNull File file) throws Exception {
        byte[] allContents = Files.readAllBytes(file.toPath());
        Arrays.stream(instance.getClass().getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).toList().forEach(f -> {
            if (!f.isAnnotationPresent(AllContents.class)) {
                return;
            }
            try {
                if (!f.getType().equals(byte[].class)) {
                    throw new ClassCastException("Fields annotated with @AllContents must be of type byte[]!");
                }
                f.setAccessible(true);
                f.set(instance, allContents);
                f.setAccessible(false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

