/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.shaded.group.aelysium.declarative_yaml.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YAMLNode {
    private final String name;
    private final Object value;
    private final List<YAMLNode> children;
    private List<String> comment;
    private boolean array = false;

    public YAMLNode(@Nullable String name, @Nullable Object value, @Nullable List<String> comment) {
        this.name = name;
        this.value = value;
        this.children = null;
        this.comment = comment;
    }

    public YAMLNode(@Nullable String name, @Nullable List<String> comment) {
        this.name = name;
        this.value = null;
        this.children = new ArrayList<YAMLNode>();
        this.comment = comment;
    }

    public String name() {
        return this.name;
    }

    public void isArray(boolean isArray) {
        this.array = isArray;
    }

    public boolean isArray() {
        return this.array;
    }

    public Optional<Object> value() {
        return Optional.ofNullable(this.value);
    }

    public Optional<String> stringifiedValue() {
        if (this.value == null) {
            return Optional.empty();
        }
        if (this.value instanceof String) {
            return Optional.of("\"" + String.valueOf(this.value) + "\"");
        }
        return Optional.of(this.value.toString());
    }

    public Optional<List<YAMLNode>> children() {
        return Optional.ofNullable(this.children);
    }

    @NotNull
    public YAMLNode setGetChild(@NotNull String key, @NotNull YAMLNode node) throws NullPointerException {
        if (this.children == null) {
            throw new NullPointerException("This node contains a value and isn't allowed to have children!");
        }
        Optional<YAMLNode> fetched = this.child(key);
        if (fetched.isPresent()) {
            return fetched.orElseThrow();
        }
        this.children.add(node);
        return node;
    }

    public Optional<YAMLNode> child(String name) {
        if (this.children == null) {
            return Optional.empty();
        }
        return this.children.stream().filter(n -> n.name.equals(name)).findFirst();
    }

    public void child(YAMLNode node) {
        if (this.children == null) {
            return;
        }
        this.children.add(node);
    }

    public Optional<List<String>> comment() {
        return Optional.ofNullable(this.comment);
    }

    public void comment(List<String> comment) {
        this.comment = comment;
    }
}

