/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.shaded.group.aelysium.haze;

import group.aelysium.rustyconnector.shaded.group.aelysium.haze.lib.DataHolder;
import group.aelysium.rustyconnector.shaded.group.aelysium.haze.requests.CreateRequest;
import group.aelysium.rustyconnector.shaded.group.aelysium.haze.requests.DeleteRequest;
import group.aelysium.rustyconnector.shaded.group.aelysium.haze.requests.ReadRequest;
import group.aelysium.rustyconnector.shaded.group.aelysium.haze.requests.UpdateRequest;
import group.aelysium.rustyconnector.shaded.group.aelysium.haze.requests.UpsertRequest;
import org.jetbrains.annotations.NotNull;

public abstract class Database
implements AutoCloseable {
    protected final Type type;
    protected final String name;

    public Database(@NotNull String name, @NotNull Type type) {
        this.type = type;
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public abstract CreateRequest newCreateRequest(@NotNull String var1);

    public abstract ReadRequest newReadRequest(@NotNull String var1);

    public abstract UpdateRequest newUpdateRequest(@NotNull String var1);

    public abstract UpsertRequest newUpsertRequest(@NotNull String var1);

    public abstract DeleteRequest newDeleteRequest(@NotNull String var1);

    public abstract void createDataHolder(@NotNull DataHolder var1) throws Exception;

    public abstract boolean doesDataHolderExist(@NotNull String var1) throws Exception;

    public abstract void deleteDataHolder(@NotNull String var1) throws Exception;

    public static enum Type {
        TABULAR,
        DOCUMENT;

    }
}

