/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.shaded.group.aelysium.haze.lib;

import group.aelysium.rustyconnector.shaded.group.aelysium.haze.lib.KeyValue;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Filter {
    private int pointer = -1;
    private final List<KeyValue<String, Value>> filters = new Vector<KeyValue<String, Value>>();
    private final List<Operator> operators = new Vector<Operator>();
    public static final Qualifier EQUALS = new Qualifier("EQUALS");
    public static final Qualifier NOT_EQUALS = new Qualifier("NOT_EQUALS");
    public static final Qualifier CONTAINS = new Qualifier("CONTAINS");
    public static final Qualifier NOT_CONTAINS = new Qualifier("NOT_CONTAINS");
    public static final Qualifier GREATER_THAN = new Qualifier("GREATER_THAN");
    public static final Qualifier LESS_THAN = new Qualifier("LESS_THAN");
    public static final Qualifier GREATER_THAN_OR_EQUAL = new Qualifier("GREATER_THAN_OR_EQUAL");
    public static final Qualifier LESS_THAN_OR_EQUAL = new Qualifier("LESS_THAN_OR_EQUAL");
    public static final Qualifier IS_NULL = new Qualifier("IS_NULL");
    public static final Qualifier IS_NOT_NULL = new Qualifier("IS_NOT_NULL");

    private Filter(@NotNull KeyValue<String, Value> initialFilter) {
        this.filters.add(initialFilter);
    }

    protected void add(@NotNull Operator operator, @NotNull KeyValue<String, Value> filter) {
        this.operators.add(operator);
        this.filters.add(filter);
    }

    public Filter AND(@NotNull String key, @NotNull Object value, @NotNull Qualifier equality) {
        this.add(Operator.AND, new KeyValue<String, Value>(key, new Value(value, equality)));
        return this;
    }

    public Filter OR(@NotNull String key, @NotNull Object value, @NotNull Qualifier equality) {
        this.add(Operator.OR, new KeyValue<String, Value>(key, new Value(value, equality)));
        return this;
    }

    public Filter AND_NOT(@NotNull String key, @NotNull Object value, @NotNull Qualifier equality) {
        this.add(Operator.AND_NOT, new KeyValue<String, Value>(key, new Value(value, equality)));
        return this;
    }

    public Filter OR_NOT(@NotNull String key, @NotNull Object value, @NotNull Qualifier equality) {
        this.add(Operator.OR_NOT, new KeyValue<String, Value>(key, new Value(value, equality)));
        return this;
    }

    public Filter XOR(@NotNull String key, @NotNull Object value, @NotNull Qualifier equality) {
        this.add(Operator.EXCLUSIVE_OR, new KeyValue<String, Value>(key, new Value(value, equality)));
        return this;
    }

    public boolean next() {
        if (this.pointer >= this.filters.size()) {
            this.pointer = this.filters.size();
            return false;
        }
        ++this.pointer;
        return true;
    }

    public void resetPointer() {
        this.pointer = -1;
    }

    @NotNull
    public @NotNull KeyValue<@Nullable Operator, @NotNull KeyValue<String, Value>> get() throws IndexOutOfBoundsException {
        Operator operator = null;
        try {
            operator = this.operators.get(this.pointer - 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        KeyValue<String, Value> value = this.filters.get(this.pointer);
        return new KeyValue<Operator, KeyValue<String, Value>>(operator, value);
    }

    public static Filter by(@NotNull String key, @NotNull Object value, @NotNull Qualifier equality) {
        return new Filter(new KeyValue<String, Value>(key, new Value(value, equality)));
    }

    public static enum Operator {
        AND,
        OR,
        AND_NOT,
        OR_NOT,
        EXCLUSIVE_OR;

    }

    public record Value(Object value, Qualifier equality) {
    }

    public record Qualifier(String value) {
        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Qualifier qualifier = (Qualifier)o;
            return Objects.equals(this.value, qualifier.value);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.value);
        }
    }
}

