/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.shaded.io.javalin.compression;

import group.aelysium.rustyconnector.shaded.io.javalin.compression.CompressedStreamKt;
import group.aelysium.rustyconnector.shaded.io.javalin.compression.CompressionStrategy;
import group.aelysium.rustyconnector.shaded.io.javalin.compression.Compressor;
import group.aelysium.rustyconnector.shaded.io.javalin.http.Context;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0012\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J \u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0003H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n \u0014*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lgroup/aelysium/rustyconnector/shaded/io/javalin/compression/CompressedOutputStream;", "Ljakarta/servlet/ServletOutputStream;", "minSizeForCompression", "", "compression", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/compression/CompressionStrategy;", "ctx", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/http/Context;", "(ILio/javalin/compression/CompressionStrategy;Lio/javalin/http/Context;)V", "compressedStream", "Ljava/io/OutputStream;", "getCompression", "()Lio/javalin/compression/CompressionStrategy;", "getCtx", "()Lio/javalin/http/Context;", "isCompressionDecisionMade", "", "getMinSizeForCompression", "()I", "originStream", "kotlin.jvm.PlatformType", "close", "", "isReady", "maybeCreateCompressionStreamOnFirstWrite", "length", "setWriteListener", "writeListener", "Ljakarta/servlet/WriteListener;", "write", "bytes", "", "offset", "byte", "javalin"})
public final class CompressedOutputStream
extends ServletOutputStream {
    private final int minSizeForCompression;
    @NotNull
    private final CompressionStrategy compression;
    @NotNull
    private final Context ctx;
    private final ServletOutputStream originStream;
    @Nullable
    private OutputStream compressedStream;
    private boolean isCompressionDecisionMade;

    public CompressedOutputStream(int minSizeForCompression, @NotNull CompressionStrategy compression, @NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)compression, (String)"compression");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.minSizeForCompression = minSizeForCompression;
        this.compression = compression;
        this.ctx = ctx;
        this.originStream = this.ctx.res().getOutputStream();
    }

    public final int getMinSizeForCompression() {
        return this.minSizeForCompression;
    }

    @NotNull
    public final CompressionStrategy getCompression() {
        return this.compression;
    }

    @NotNull
    public final Context getCtx() {
        return this.ctx;
    }

    private final void maybeCreateCompressionStreamOnFirstWrite(int length) {
        if (!this.isCompressionDecisionMade) {
            boolean isCompressionDesired;
            boolean isCompressionAllowed = !this.ctx.res().containsHeader("Content-Encoding") && CompressedStreamKt.access$allowsForCompression(this.compression, this.ctx.res().getContentType());
            boolean bl = isCompressionDesired = length >= this.minSizeForCompression;
            if (isCompressionAllowed && isCompressionDesired) {
                Compressor compressor = CompressedStreamKt.access$findMatchingCompressor(this.compression, this.ctx);
                if (compressor != null) {
                    Compressor compressor2;
                    Compressor it = compressor2 = compressor;
                    boolean bl2 = false;
                    ServletOutputStream servletOutputStream = this.originStream;
                    Intrinsics.checkNotNullExpressionValue((Object)servletOutputStream, (String)"originStream");
                    this.compressedStream = it.compress((OutputStream)servletOutputStream);
                    this.ctx.header("Content-Encoding", it.encoding());
                }
            }
            this.isCompressionDecisionMade = true;
        }
    }

    public void write(@NotNull byte[] bytes, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.maybeCreateCompressionStreamOnFirstWrite(length);
        OutputStream outputStream = this.compressedStream;
        if (outputStream == null) {
            outputStream = (OutputStream)this.originStream;
        }
        outputStream.write(bytes, offset, length);
    }

    public void write(int n) {
        this.maybeCreateCompressionStreamOnFirstWrite(1);
        OutputStream outputStream = this.compressedStream;
        if (outputStream == null) {
            outputStream = (OutputStream)this.originStream;
        }
        outputStream.write(n);
    }

    public void setWriteListener(@Nullable WriteListener writeListener) {
        this.originStream.setWriteListener(writeListener);
    }

    public boolean isReady() {
        return this.originStream.isReady();
    }

    public void close() {
        block0: {
            OutputStream outputStream = this.compressedStream;
            if (outputStream == null) break block0;
            outputStream.close();
        }
    }
}

