/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.shaded.io.javalin.config;

import group.aelysium.rustyconnector.shaded.io.javalin.config.JavalinConfig;
import group.aelysium.rustyconnector.shaded.io.javalin.config.MultipartConfig;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.server.JettyWebSocketServletFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\r\u001a\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010J\u0014\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016J\u0014\u0010\u0017\u001a\u00020\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016J\u0014\u0010\u0019\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016J\u0014\u0010\u001c\u001a\u00020\u000e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lgroup/aelysium/rustyconnector/shaded/io/javalin/config/JettyConfig;", "", "cfg", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/config/JavalinConfig;", "(Lio/javalin/config/JavalinConfig;)V", "defaultHost", "", "defaultPort", "", "multipartConfig", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/config/MultipartConfig;", "threadPool", "Lorg/eclipse/jetty/util/thread/ThreadPool;", "addConnector", "", "connector", "Ljava/util/function/BiFunction;", "Lorg/eclipse/jetty/server/Server;", "Lorg/eclipse/jetty/server/HttpConfiguration;", "Lorg/eclipse/jetty/server/Connector;", "modifyHttpConfiguration", "httpConfigurationConfig", "Ljava/util/function/Consumer;", "modifyServer", "server", "modifyServletContextHandler", "consumer", "Lorg/eclipse/jetty/servlet/ServletContextHandler;", "modifyWebSocketServletFactory", "wsFactoryConfig", "Lorg/eclipse/jetty/websocket/server/JettyWebSocketServletFactory;", "javalin"})
public final class JettyConfig {
    @NotNull
    private final JavalinConfig cfg;
    @JvmField
    @Nullable
    public String defaultHost;
    @JvmField
    public int defaultPort;
    @JvmField
    @NotNull
    public MultipartConfig multipartConfig;
    @JvmField
    @Nullable
    public ThreadPool threadPool;

    public JettyConfig(@NotNull JavalinConfig cfg) {
        Intrinsics.checkNotNullParameter((Object)cfg, (String)"cfg");
        this.cfg = cfg;
        this.defaultPort = 8080;
        this.multipartConfig = new MultipartConfig();
    }

    public final void modifyServer(@NotNull Consumer<Server> server) {
        Intrinsics.checkNotNullParameter(server, (String)"server");
        this.cfg.pvt.jetty.serverConsumers.add(server);
    }

    public final void modifyServletContextHandler(@NotNull Consumer<ServletContextHandler> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.cfg.pvt.jetty.servletContextHandlerConsumers.add(consumer);
    }

    public final void modifyWebSocketServletFactory(@NotNull Consumer<JettyWebSocketServletFactory> wsFactoryConfig) {
        Intrinsics.checkNotNullParameter(wsFactoryConfig, (String)"wsFactoryConfig");
        this.cfg.pvt.jetty.wsFactoryConfigs.add(wsFactoryConfig);
    }

    public final void modifyHttpConfiguration(@NotNull Consumer<HttpConfiguration> httpConfigurationConfig) {
        Intrinsics.checkNotNullParameter(httpConfigurationConfig, (String)"httpConfigurationConfig");
        this.cfg.pvt.jetty.httpConfigurationConfigs.add(httpConfigurationConfig);
    }

    public final void addConnector(@NotNull BiFunction<Server, HttpConfiguration, Connector> connector) {
        Intrinsics.checkNotNullParameter(connector, (String)"connector");
        this.cfg.pvt.jetty.connectors.add(connector);
    }
}

