/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.shaded.io.javalin.router;

import group.aelysium.rustyconnector.shaded.io.javalin.config.RouterConfig;
import group.aelysium.rustyconnector.shaded.io.javalin.event.EventManager;
import group.aelysium.rustyconnector.shaded.io.javalin.event.HandlerMetaInfo;
import group.aelysium.rustyconnector.shaded.io.javalin.event.WsHandlerMetaInfo;
import group.aelysium.rustyconnector.shaded.io.javalin.http.Context;
import group.aelysium.rustyconnector.shaded.io.javalin.http.ExceptionHandler;
import group.aelysium.rustyconnector.shaded.io.javalin.http.Handler;
import group.aelysium.rustyconnector.shaded.io.javalin.http.HandlerType;
import group.aelysium.rustyconnector.shaded.io.javalin.router.Endpoint;
import group.aelysium.rustyconnector.shaded.io.javalin.router.ParsedEndpoint;
import group.aelysium.rustyconnector.shaded.io.javalin.router.error.ErrorMapper;
import group.aelysium.rustyconnector.shaded.io.javalin.router.exception.ExceptionMapper;
import group.aelysium.rustyconnector.shaded.io.javalin.router.matcher.PathMatcher;
import group.aelysium.rustyconnector.shaded.io.javalin.security.Roles;
import group.aelysium.rustyconnector.shaded.io.javalin.security.RouteRole;
import group.aelysium.rustyconnector.shaded.io.javalin.util.Util;
import group.aelysium.rustyconnector.shaded.io.javalin.websocket.WsConfig;
import group.aelysium.rustyconnector.shaded.io.javalin.websocket.WsExceptionHandler;
import group.aelysium.rustyconnector.shaded.io.javalin.websocket.WsHandlerEntry;
import group.aelysium.rustyconnector.shaded.io.javalin.websocket.WsHandlerType;
import group.aelysium.rustyconnector.shaded.io.javalin.websocket.WsRouter;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J4\u0010\u001f\u001a\u00020\u0000\"\f\b\u0000\u0010 *\u00060!j\u0002`\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H 0$2\u000e\u0010%\u001a\n\u0012\u0006\b\u0000\u0012\u0002H 0&H\u0016J4\u0010'\u001a\u00020\u0000\"\f\b\u0000\u0010 *\u00060!j\u0002`\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H 0$2\u000e\u0010%\u001a\n\u0012\u0006\b\u0000\u0012\u0002H 0(H\u0016J?\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001c2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0012\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020201\"\u000202H\u0016\u00a2\u0006\u0002\u00103J\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\f\u00107\u001a\b\u0012\u0004\u0012\u00020805J\"\u00109\u001a\b\u0012\u0004\u0012\u0002060:2\u0006\u0010*\u001a\u00020;2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\u001cH\u0016J\u0018\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020AH\u0016J\u0018\u0010B\u001a\u00020>2\u0006\u0010@\u001a\u00020A2\u0006\u0010C\u001a\u00020DH\u0016J\u001a\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u00020H2\u0006\u0010C\u001a\u00020DH\u0016J\u0018\u0010I\u001a\u00020J2\u0006\u0010*\u001a\u00020;2\u0006\u0010<\u001a\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lgroup/aelysium/rustyconnector/shaded/io/javalin/router/InternalRouter;", "", "wsRouter", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/websocket/WsRouter;", "eventManager", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/event/EventManager;", "routerConfig", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/config/RouterConfig;", "(Lio/javalin/websocket/WsRouter;Lio/javalin/event/EventManager;Lio/javalin/config/RouterConfig;)V", "httpErrorMapper", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/router/error/ErrorMapper;", "getHttpErrorMapper", "()Lio/javalin/router/error/ErrorMapper;", "httpExceptionMapper", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/router/exception/ExceptionMapper;", "getHttpExceptionMapper", "()Lio/javalin/router/exception/ExceptionMapper;", "httpPathMatcher", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/router/matcher/PathMatcher;", "getHttpPathMatcher", "()Lio/javalin/router/matcher/PathMatcher;", "addHttpEndpoint", "endpoint", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/router/Endpoint;", "addHttpErrorHandler", "status", "", "contentType", "", "handler", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/http/Handler;", "addHttpExceptionHandler", "E", "Ljava/lang/Exception;", "Lkotlin/Exception;", "exceptionClass", "Ljava/lang/Class;", "exceptionHandler", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/http/ExceptionHandler;", "addWsExceptionHandler", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/websocket/WsExceptionHandler;", "addWsHandler", "handlerType", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/websocket/WsHandlerType;", "path", "wsConfig", "Ljava/util/function/Consumer;", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/websocket/WsConfig;", "roles", "", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/security/RouteRole;", "(Lio/javalin/websocket/WsHandlerType;Ljava/lang/String;Ljava/util/function/Consumer;[Lio/javalin/security/RouteRole;)Lio/javalin/router/InternalRouter;", "allHttpHandlers", "", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/router/ParsedEndpoint;", "allWsHandlers", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/websocket/WsHandlerEntry;", "findHttpHandlerEntries", "Ljava/util/stream/Stream;", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/http/HandlerType;", "requestUri", "handleHttpError", "", "statusCode", "ctx", "Lgroup/aelysium/rustyconnector/shaded/io/javalin/http/Context;", "handleHttpException", "throwable", "", "handleHttpUnexpectedThrowable", "", "res", "Ljakarta/servlet/http/HttpServletResponse;", "hasHttpHandlerEntry", "", "javalin"})
public class InternalRouter {
    @NotNull
    private final WsRouter wsRouter;
    @NotNull
    private final EventManager eventManager;
    @NotNull
    private final RouterConfig routerConfig;
    @NotNull
    private final PathMatcher httpPathMatcher;
    @NotNull
    private final ErrorMapper httpErrorMapper;
    @NotNull
    private final ExceptionMapper httpExceptionMapper;

    public InternalRouter(@NotNull WsRouter wsRouter, @NotNull EventManager eventManager2, @NotNull RouterConfig routerConfig) {
        Intrinsics.checkNotNullParameter((Object)wsRouter, (String)"wsRouter");
        Intrinsics.checkNotNullParameter((Object)eventManager2, (String)"eventManager");
        Intrinsics.checkNotNullParameter((Object)routerConfig, (String)"routerConfig");
        this.wsRouter = wsRouter;
        this.eventManager = eventManager2;
        this.routerConfig = routerConfig;
        this.httpPathMatcher = new PathMatcher();
        this.httpErrorMapper = new ErrorMapper();
        this.httpExceptionMapper = new ExceptionMapper(this.routerConfig);
    }

    @NotNull
    protected PathMatcher getHttpPathMatcher() {
        return this.httpPathMatcher;
    }

    @NotNull
    protected ErrorMapper getHttpErrorMapper() {
        return this.httpErrorMapper;
    }

    @NotNull
    protected ExceptionMapper getHttpExceptionMapper() {
        return this.httpExceptionMapper;
    }

    @NotNull
    public InternalRouter addHttpEndpoint(@NotNull Endpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        this.getHttpPathMatcher().add(new ParsedEndpoint(endpoint, this.routerConfig));
        HandlerType handlerType = endpoint.getMethod();
        String string = Util.prefixContextPath(this.routerConfig.contextPath, endpoint.getPath());
        Handler handler = endpoint.getHandler();
        Object object = endpoint.metadata(Roles.class);
        if (object == null || (object = ((Roles)object).getRoles()) == null) {
            object = SetsKt.emptySet();
        }
        this.eventManager.fireHandlerAddedEvent(new HandlerMetaInfo(handlerType, string, handler, (Set<? extends RouteRole>)object));
        return this;
    }

    @NotNull
    public final List<ParsedEndpoint> allHttpHandlers() {
        return this.getHttpPathMatcher().allEntries();
    }

    public boolean hasHttpHandlerEntry(@NotNull HandlerType handlerType, @NotNull String requestUri) {
        Intrinsics.checkNotNullParameter((Object)((Object)handlerType), (String)"handlerType");
        Intrinsics.checkNotNullParameter((Object)requestUri, (String)"requestUri");
        return this.getHttpPathMatcher().hasEntries$javalin(handlerType, requestUri);
    }

    @NotNull
    public Stream<ParsedEndpoint> findHttpHandlerEntries(@NotNull HandlerType handlerType, @Nullable String requestUri) {
        Intrinsics.checkNotNullParameter((Object)((Object)handlerType), (String)"handlerType");
        return this.getHttpPathMatcher().findEntries(handlerType, requestUri);
    }

    public static /* synthetic */ Stream findHttpHandlerEntries$default(InternalRouter internalRouter, HandlerType handlerType, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findHttpHandlerEntries");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return internalRouter.findHttpHandlerEntries(handlerType, string);
    }

    @NotNull
    public InternalRouter addHttpErrorHandler(int status, @NotNull String contentType, @NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.getHttpErrorMapper().addHandler(status, contentType, handler);
        return this;
    }

    public void handleHttpError(int statusCode, @NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.getHttpErrorMapper().handle(statusCode, ctx);
    }

    @NotNull
    public <E extends Exception> InternalRouter addHttpExceptionHandler(@NotNull Class<E> exceptionClass, @NotNull ExceptionHandler<? super E> exceptionHandler) {
        Intrinsics.checkNotNullParameter(exceptionClass, (String)"exceptionClass");
        Intrinsics.checkNotNullParameter(exceptionHandler, (String)"exceptionHandler");
        this.getHttpExceptionMapper().getHandlers().put(exceptionClass, exceptionHandler);
        return this;
    }

    public void handleHttpException(@NotNull Context ctx, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.getHttpExceptionMapper().handle$javalin(ctx, throwable);
    }

    @Nullable
    public Void handleHttpUnexpectedThrowable(@NotNull HttpServletResponse res, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        return this.getHttpExceptionMapper().handleUnexpectedThrowable$javalin(res, throwable);
    }

    @NotNull
    public <E extends Exception> InternalRouter addWsExceptionHandler(@NotNull Class<E> exceptionClass, @NotNull WsExceptionHandler<? super E> exceptionHandler) {
        Intrinsics.checkNotNullParameter(exceptionClass, (String)"exceptionClass");
        Intrinsics.checkNotNullParameter(exceptionHandler, (String)"exceptionHandler");
        this.wsRouter.getWsExceptionMapper().getHandlers().put(exceptionClass, exceptionHandler);
        return this;
    }

    @NotNull
    public InternalRouter addWsHandler(@NotNull WsHandlerType handlerType, @NotNull String path, @NotNull Consumer<WsConfig> wsConfig, RouteRole ... roles) {
        Intrinsics.checkNotNullParameter((Object)((Object)handlerType), (String)"handlerType");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(wsConfig, (String)"wsConfig");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        HashSet roleSet = new HashSet(ArraysKt.asList((Object[])roles));
        this.wsRouter.addHandler(handlerType, path, wsConfig, roleSet);
        this.eventManager.fireWsHandlerAddedEvent(new WsHandlerMetaInfo(handlerType, Util.prefixContextPath(this.routerConfig.contextPath, path), wsConfig, roleSet));
        return this;
    }

    @NotNull
    public final List<WsHandlerEntry> allWsHandlers() {
        return this.wsRouter.getWsPathMatcher().allEntries();
    }
}

