/*
 * Decompiled with CFR 0.152.
 */
package group.aelysium.rustyconnector.shaded.io.javalin.vue;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\b\n\u0000\n\u0002\u0010\u000e\n\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0002"}, d2={"loadableDataScript", "", "javalin"})
public final class LoadableDataKt {
    @NotNull
    public static final String loadableDataScript = "\n\n<script nonce=\"@internalAddNonce\">\n    class LoadableData {\n        constructor(url, options = {cache: false, errorCallback: null}) {\n            this.isVue2 = Vue.version?.startsWith(\"2\") ?? true;\n            this._url = url;\n            this._errorCallback = options.errorCallback ?? null;\n            if (this.isVue2) {\n              this.data = null;\n              this.loading = true;\n              this.refreshing = false;\n              this.loaded = false;\n              this.loadError = null;\n            } else {\n              this.data = Vue.ref(null);\n              this.loading = Vue.ref(true);\n              this.refreshing = Vue.ref(false);\n              this.loaded = Vue.ref(false);\n              this.loadError = Vue.ref(null);\n            }\n        \n            this._load(options.cache ?? false); // initial load\n            this.addRefreshListener(); // listen for global refresh events\n          }\n          _load(cache = false) {\n            let cacheKey = \"LoadableData:\" + this._url;\n            if (cache) {\n              this.data = JSON.parse(localStorage.getItem(cacheKey)) || null;\n              if (this.isVue2) {\n                this.loaded = this.data !== null;\n                this.loading = this.loaded === false;\n              } else {\n                this.loaded.value = this.data.value !== null;\n                this.loading.value = !this.loaded.value;\n              }\n            }\n            fetch(this._url).then(res => {\n                if (res.ok) return res.json();\n                throw { code: res.status, text: res.statusText };\n              }).then(data => {\n                if (this.isVue2) {\n                  this.data = data;\n                  this.loaded = true;\n                } else {\n                  this.data.value = data;\n                  this.loaded.value = true;\n                }\n                if (cache) {\n                  localStorage.setItem(cacheKey, JSON.stringify(data));\n                }\n              }).catch(error => {\n                if (this.isVue2) {\n                  this.loadError = error;\n                } else {\n                  this.loadError.value = error;\n                }\n                if (this._errorCallback !== null) {\n                  this._errorCallback(error);\n                }\n              }).finally(() => {\n                if (this.isVue2) {\n                  this.loading = false;\n                  this.refreshing = false;\n                } else {\n                  this.loading.value = false;\n                  this.refreshing.value = false;\n                }\n              });\n          }\n          refresh() {\n            if (this.isVue2) {\n              this.refreshing = true;\n            } else {\n              this.refreshing.value = true;\n            }\n            this._load(false); // refresh doesn't clear data, so no need to cache\n          }\n          refreshAll() {\n            window.dispatchEvent(new CustomEvent(\"loadabledata-refresh\", {detail: this._url}));\n          }\n          invalidateCache() {\n            localStorage.removeItem(\"LoadableData:\" + this._url);\n          }\n          addRefreshListener() {\n            window.addEventListener(\"loadabledata-refresh\", e => {\n                if (this._url === e.detail) {\n                  this.refresh();\n                }\n              }, false);\n          }\n    }\n</script>";
}

