/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.googlechat;

import io.gitlab.jfronny.commons.serialize.annotations.Ignore;
import io.gitlab.jfronny.googlechat.GoogleChat;
import io.gitlab.jfronny.googlechat.JFC_GoogleChatConfig;
import io.gitlab.jfronny.libjf.config.api.v2.Category;
import io.gitlab.jfronny.libjf.config.api.v2.Entry;
import io.gitlab.jfronny.libjf.config.api.v2.JfConfig;
import io.gitlab.jfronny.libjf.config.api.v2.Preset;
import io.gitlab.jfronny.libjf.config.api.v2.Verifier;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.CategoryBuilder;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.ConfigBuilder;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.Migration;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;

@JfConfig(tweaker=GoogleChatConfig.class)
public class GoogleChatConfig {
    @Ignore
    private static boolean initial = true;

    @Verifier
    public static void verify() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER && !General.clientLanguage.equals("auto")) {
            System.err.println("Your client language is not set to \"auto\" and you are using a server.\nThis setup is not recommended! Please set up GoogleChat according to its documentation!");
        }
        if (!initial) {
            GoogleChat.onConfigChange();
        }
        initial = false;
    }

    public static ConfigBuilder<?> tweak(ConfigBuilder<?> builder) {
        return (ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)builder.addMigration("enabled", Migration.of(reader -> {
            General.enabled = reader.nextBoolean();
        }))).addMigration("serverLanguage", Migration.of(reader -> {
            General.serverLanguage = reader.nextString();
        }))).addMigration("clientLanguage", Migration.of(reader -> {
            General.clientLanguage = reader.nextString();
        }))).addMigration("translationTooltip", Migration.of(reader -> General.translationTooltip(reader.nextBoolean())))).addMigration("desugar", Migration.of(reader -> {
            Processing.desugar = reader.nextBoolean();
        }))).addMigration("receivingRegex", Migration.of(reader -> {
            Processing.receivingRegex = reader.nextString();
        }))).addMigration("receivingRegexIsBlacklist", Migration.of(reader -> {
            Processing.receivingRegexIsBlacklist = reader.nextBoolean();
        }))).addMigration("sendingRegex", Migration.of(reader -> {
            Processing.sendingRegex = reader.nextString();
        }))).addMigration("sendingRegexIsBlacklist", Migration.of(reader -> {
            Processing.sendingRegexIsBlacklist = reader.nextBoolean();
        }))).addMigration("cacheSize", Migration.of(reader -> {
            Advanced.cacheSize = reader.nextInt();
        }))).addMigration("debugLogs", Migration.of(reader -> {
            Advanced.debugLogs = reader.nextBoolean();
        }));
    }

    static {
        JFC_GoogleChatConfig.ensureInitialized();
    }

    @Category(referencedConfigs={"libjf-translate-v1"}, tweaker=General.class)
    public static class General {
        @Entry
        public static boolean enabled = true;
        @Entry
        public static String serverLanguage = "auto";
        @Entry
        public static String clientLanguage = "en";
        @Entry
        public static DisplayMode displayMode = DisplayMode.REPLACE;

        @Preset
        public static void client() {
            enabled = true;
            if (!serverLanguage.equals("auto")) {
                serverLanguage = "auto";
                clientLanguage = "en";
            }
        }

        @Preset
        public static void server() {
            enabled = true;
            if (!clientLanguage.equals("auto")) {
                clientLanguage = "auto";
                serverLanguage = "en";
            }
        }

        public static CategoryBuilder<?> tweak(CategoryBuilder<?> builder) {
            return builder.addMigration("translationTooltip", Migration.of(reader -> General.translationTooltip(reader.nextBoolean())));
        }

        private static void translationTooltip(boolean value) {
            displayMode = value ? DisplayMode.TOOLTIP : DisplayMode.REPLACE;
        }

        public static enum DisplayMode {
            REPLACE,
            TOOLTIP,
            APPEND;

        }
    }

    @Category
    public static class Advanced {
        @Entry(min=1.0, max=1024.0)
        public static int cacheSize = 256;
        @Entry
        public static boolean async = true;
        @Entry
        public static boolean translateMessageArguments = true;
        @Entry
        public static boolean debugLogs = FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Category
    public static class Processing {
        @Entry
        public static boolean desugar = false;
        @Entry
        public static String receivingRegex = "";
        @Entry
        public static boolean receivingRegexIsBlacklist = true;
        @Entry
        public static String sendingRegex = "";
        @Entry
        public static boolean sendingRegexIsBlacklist = true;
    }
}

