/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.googlechat;

import io.gitlab.jfronny.googlechat.GoogleChatConfig;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;

public enum TranslationDirection {
    C2S,
    S2C;


    public String source() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> GoogleChatConfig.General.clientLanguage;
            case 1 -> GoogleChatConfig.General.serverLanguage;
        };
    }

    public String target() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> GoogleChatConfig.General.serverLanguage;
            case 1 -> GoogleChatConfig.General.clientLanguage;
        };
    }

    public boolean hasTarget() {
        return !this.target().equals("auto");
    }

    public boolean shouldSkipOutright() {
        if (!GoogleChatConfig.General.enabled) {
            return true;
        }
        return !this.hasTarget();
    }

    public boolean failsRegex(String text) {
        boolean isSender;
        boolean bl = isSender = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT == (this == C2S);
        if (isSender) {
            return text.matches(GoogleChatConfig.Processing.sendingRegex) == GoogleChatConfig.Processing.sendingRegexIsBlacklist;
        }
        return text.matches(GoogleChatConfig.Processing.receivingRegex) == GoogleChatConfig.Processing.receivingRegexIsBlacklist;
    }

    record Split<T>(T c2s, T s2c) {
        public static <T> Split<T> of(Supplier<T> supply) {
            return new Split<T>(supply.get(), supply.get());
        }

        public T get(TranslationDirection direction) {
            return direction == C2S ? this.c2s : this.s2c;
        }

        public Stream<T> stream() {
            return Stream.of(this.c2s, this.s2c);
        }
    }
}

