/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.googlechat.client.mixin;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.ParsedArgument;
import io.gitlab.jfronny.googlechat.GoogleChat;
import io.gitlab.jfronny.googlechat.GoogleChatConfig;
import io.gitlab.jfronny.googlechat.TranslationDirection;
import io.gitlab.jfronny.googlechat.client.GoogleChatClient;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2196;
import net.minecraft.class_634;
import net.minecraft.class_637;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_634.class})
public class ClientPlayNetworkHandlerMixin {
    @Shadow
    private CommandDispatcher<class_637> field_3696;
    @Shadow
    @Final
    private class_637 field_3691;
    @Unique
    private final AtomicReference<ParseResults<class_637>> googlechat$lastResults = new AtomicReference<Object>(null);

    @ModifyVariable(method={"sendChatCommand(Ljava/lang/String;)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    public String translateCommand(String command) {
        ParseResults results = this.field_3696.parse(command, (Object)this.field_3691);
        if (!(GoogleChatConfig.General.enabled && GoogleChatConfig.Advanced.translateMessageArguments && results.getExceptions().isEmpty())) {
            return command;
        }
        boolean[] modified = new boolean[]{false};
        results.getContext().getArguments().replaceAll((key, value) -> {
            Object patt0$temp = value.getResult();
            if (patt0$temp instanceof class_2196.class_2197) {
                class_2196.class_2197 fmt = (class_2196.class_2197)patt0$temp;
                if (fmt.comp_2654().length != 0) {
                    return value;
                }
                fmt = new class_2196.class_2197(GoogleChat.translateIfNeeded(fmt.comp_2653(), TranslationDirection.C2S, true), new class_2196.class_2198[0]);
                modified[0] = true;
                return new ParsedArgument(value.getRange().getStart(), value.getRange().getEnd(), (Object)fmt);
            }
            return value;
        });
        if (!modified[0]) {
            return command;
        }
        return GoogleChatClient.reconstitute(command, results.getContext()).map(s -> {
            this.googlechat$lastResults.set((ParseResults<class_637>)results);
            return s;
        }).orElse(command);
    }

    @Redirect(method={"sendChatCommand(Ljava/lang/String;)V"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/CommandDispatcher;parse(Ljava/lang/String;Ljava/lang/Object;)Lcom/mojang/brigadier/ParseResults;", remap=false))
    public <S> ParseResults<S> googlechat$modifyArguments(CommandDispatcher<S> instance, String command, S source) {
        ParseResults results = this.googlechat$lastResults.getAndSet(null);
        if (results == null) {
            return instance.parse(command, source);
        }
        return results;
    }
}

