/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.googlechat.client.mixin;

import com.mojang.authlib.GameProfile;
import io.gitlab.jfronny.googlechat.GoogleChat;
import io.gitlab.jfronny.googlechat.GoogleChatConfig;
import io.gitlab.jfronny.googlechat.TranslationDirection;
import java.time.Instant;
import java.util.Deque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_333;
import net.minecraft.class_338;
import net.minecraft.class_7469;
import net.minecraft.class_7471;
import net.minecraft.class_7591;
import net.minecraft.class_7594;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_7594.class})
public abstract class MessageHandlerMixin {
    @Shadow
    @Final
    private class_310 field_39779;
    @Shadow
    @Final
    private Deque<class_7594.class_7627> field_39796;
    @Unique
    CompletableFuture<Void> googlechat$currentFuture = CompletableFuture.completedFuture(null);
    @Unique
    ThreadLocal<GameProfile> sender = new ThreadLocal();

    @Shadow
    protected abstract void method_44772(class_2556.class_7602 var1, class_2561 var2);

    @Redirect(method={"onGameMessage(Lnet/minecraft/text/Text;Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/hud/InGameHud;setOverlayMessage(Lnet/minecraft/text/Text;Z)V"))
    private void googlechat$onGameMessage$setOverlayMessage(class_329 instance, class_2561 message, boolean tinted) {
        if (this.googlechat$shouldTranslate()) {
            this.googlechat$scheduleS2C(message, msg -> instance.method_1758(msg, tinted));
        } else {
            instance.method_1758(message, tinted);
        }
    }

    @Redirect(method={"onGameMessage(Lnet/minecraft/text/Text;Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/hud/ChatHud;addMessage(Lnet/minecraft/text/Text;)V"))
    private void googlechat$onGameMessage$addMessage(class_338 instance, class_2561 text) {
        if (this.googlechat$shouldTranslate()) {
            this.googlechat$scheduleS2C(text, arg_0 -> ((class_338)instance).method_1812(arg_0));
        } else {
            instance.method_1812(text);
        }
    }

    @Redirect(method={"onGameMessage(Lnet/minecraft/text/Text;Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/util/NarratorManager;narrateSystemMessage(Lnet/minecraft/text/Text;)V"))
    private void googlechat$onGameMessage$narrateSystemMessage(class_333 instance, class_2561 text) {
        if (this.googlechat$shouldTranslate()) {
            this.googlechat$scheduleS2C(text, arg_0 -> ((class_333)instance).method_47976(arg_0));
        } else {
            instance.method_47976(text);
        }
    }

    @Redirect(method={"method_45745(Lnet/minecraft/network/message/MessageType$Parameters;Lnet/minecraft/text/Text;Ljava/time/Instant;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/hud/ChatHud;addMessage(Lnet/minecraft/text/Text;)V"))
    private void googlechat$onProfilelessMessage$addMessage(class_338 instance, class_2561 text) {
        if (this.googlechat$shouldTranslate()) {
            this.googlechat$scheduleS2C(text, arg_0 -> ((class_338)instance).method_1812(arg_0));
        } else {
            instance.method_1812(text);
        }
    }

    @Redirect(method={"method_45745(Lnet/minecraft/network/message/MessageType$Parameters;Lnet/minecraft/text/Text;Ljava/time/Instant;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/network/message/MessageHandler;narrate(Lnet/minecraft/network/message/MessageType$Parameters;Lnet/minecraft/text/Text;)V"))
    private void googlechat$onProfilelessMessage$narrate(class_7594 instance, class_2556.class_7602 params, class_2561 message) {
        if (instance != this) {
            GoogleChat.LOGGER.warn("Mismatched message handler in onGameMessage", new Object[0]);
        }
        if (this.googlechat$shouldTranslate()) {
            this.googlechat$scheduleS2C(message, msg -> this.method_44772(params, (class_2561)msg));
        } else {
            this.method_44772(params, message);
        }
    }

    @Inject(method={"onChatMessage(Lnet/minecraft/network/message/SignedMessage;Lcom/mojang/authlib/GameProfile;Lnet/minecraft/network/message/MessageType$Parameters;)V"}, at={@At(value="HEAD")})
    private void googlechat$onChatMessage$extractSender(class_7471 message, GameProfile sender, class_2556.class_7602 params, CallbackInfo ci) {
        this.sender.set(sender);
    }

    @Redirect(method={"processChatMessageInternal(Lnet/minecraft/network/message/MessageType$Parameters;Lnet/minecraft/network/message/SignedMessage;Lnet/minecraft/text/Text;Lcom/mojang/authlib/GameProfile;ZLjava/time/Instant;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/hud/ChatHud;addMessage(Lnet/minecraft/text/Text;Lnet/minecraft/network/message/MessageSignatureData;Lnet/minecraft/client/gui/hud/MessageIndicator;)V"))
    private void googlechat$processChatMessageInternal$addMessage(class_338 instance, class_2561 message, class_7469 signature, class_7591 indicator) {
        if (this.googlechat$shouldTranslate()) {
            this.googlechat$scheduleS2C(message, msg -> instance.method_44811(msg, signature, indicator));
        } else {
            instance.method_44811(message, signature, indicator);
        }
    }

    @Redirect(method={"processChatMessageInternal(Lnet/minecraft/network/message/MessageType$Parameters;Lnet/minecraft/network/message/SignedMessage;Lnet/minecraft/text/Text;Lcom/mojang/authlib/GameProfile;ZLjava/time/Instant;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/network/message/MessageHandler;narrate(Lnet/minecraft/network/message/MessageType$Parameters;Lnet/minecraft/text/Text;)V"))
    private void googlechat$processChatMessageInternal$narrate(class_7594 instance, class_2556.class_7602 params, class_2561 message) {
        if (instance != this) {
            GoogleChat.LOGGER.warn("Mismatched message handler in onGameMessage", new Object[0]);
        }
        if (this.googlechat$shouldTranslate()) {
            this.googlechat$scheduleS2C(message, msg -> this.method_44772(params, (class_2561)msg));
        } else {
            this.method_44772(params, message);
        }
    }

    @Inject(method={"processChatMessageInternal(Lnet/minecraft/network/message/MessageType$Parameters;Lnet/minecraft/network/message/SignedMessage;Lnet/minecraft/text/Text;Lcom/mojang/authlib/GameProfile;ZLjava/time/Instant;)Z"}, at={@At(value="RETURN")})
    private void googlechat$processChatMessageInternal$clearSender(class_2556.class_7602 params, class_7471 message, class_2561 decorated, GameProfile sender, boolean onlyShowSecureChat, Instant receptionTimestamp, CallbackInfoReturnable<Boolean> cir) {
        this.sender.remove();
    }

    @Unique
    private class_2561 googlechat$s2c(class_2561 message) {
        return GoogleChat.translateIfNeeded(message, TranslationDirection.S2C, true);
    }

    @Unique
    private void googlechat$scheduleS2C(class_2561 message, Consumer<class_2561> runnable) {
        if (!GoogleChatConfig.Advanced.async) {
            runnable.accept(this.googlechat$s2c(message));
        } else {
            this.googlechat$currentFuture = ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.googlechat$currentFuture.handleAsync((_1, _2) -> this.googlechat$s2c(message), (Executor)Executors.newVirtualThreadPerTaskExecutor())).whenCompleteAsync((msg, _2) -> this.field_39796.add(new class_7594.class_7627(null, () -> {
                runnable.accept((class_2561)msg);
                return false;
            })), (Executor)Executors.newVirtualThreadPerTaskExecutor())).exceptionally(throwable -> {
                GoogleChat.LOGGER.error("Something went wrong while processing a message", throwable);
                return null;
            })).handle((_1, _2) -> null);
        }
    }

    @Unique
    private boolean googlechat$shouldTranslate() {
        if (!GoogleChatConfig.General.enabled) {
            return false;
        }
        if (this.field_39779 == null || this.field_39779.field_1724 == null) {
            return false;
        }
        GameProfile sender = this.sender.get();
        if (sender == null) {
            return true;
        }
        return !sender.id().equals(this.field_39779.field_1724.method_5667());
    }
}

