/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.googlechat.server;

import io.gitlab.jfronny.googlechat.GoogleChat;
import io.gitlab.jfronny.googlechat.GoogleChatConfig;
import io.gitlab.jfronny.googlechat.TranslationDirection;
import io.gitlab.jfronny.googlechat.server.TranslatableContainer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.message.v1.ServerMessageDecoratorEvent;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7492;
import org.jetbrains.annotations.Nullable;

public class GoogleChatServer
implements DedicatedServerModInitializer,
class_7492 {
    public void onInitializeServer() {
        ServerMessageDecoratorEvent.EVENT.register(Event.DEFAULT_PHASE, (Object)this);
    }

    public class_2561 decorate(@Nullable class_3222 sender, class_2561 original) {
        if (!GoogleChatConfig.General.enabled) {
            return original;
        }
        if (!GoogleChatConfig.Advanced.async) {
            return this.decorate(sender, new TranslatableContainer.Sync(original)).text();
        }
        try {
            return (class_2561)((CompletableFuture)this.decorate(sender, new TranslatableContainer.Async(CompletableFuture.completedFuture(original))).text().exceptionally(e -> {
                GoogleChat.LOGGER.error("Could not compute translation", e);
                return original;
            })).get();
        }
        catch (InterruptedException | ExecutionException e2) {
            GoogleChat.LOGGER.error("Could not synchronize async translation for synchronous decorator", (Throwable)e2);
            return original;
        }
    }

    private <K, T extends TranslatableContainer<K, T>> T decorate(@Nullable class_3222 sender, T original) {
        T message = original;
        if (sender != null) {
            if (TranslationDirection.C2S.hasTarget() && TranslationDirection.S2C.hasTarget()) {
                return message;
            }
            message = message.translate(TranslationDirection.C2S);
        }
        message = message.translate(TranslationDirection.S2C);
        return message;
    }
}

