/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.googlechat.server;

import io.gitlab.jfronny.googlechat.GoogleChat;
import io.gitlab.jfronny.googlechat.GoogleChatConfig;
import io.gitlab.jfronny.googlechat.TranslationDirection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;

public sealed interface TranslatableContainer<T, S extends TranslatableContainer<T, S>> {
    public S translate(TranslationDirection var1);

    public static class_2561 translateAndLog(class_2561 source, TranslationDirection direction) {
        class_2561 translated = GoogleChat.translateIfNeeded(source, direction, true);
        if (GoogleChatConfig.Advanced.debugLogs) {
            GoogleChat.LOGGER.info("Applied C2S translation from {0} to {1}", new Object[]{source, translated});
        }
        return translated;
    }

    public record Async(CompletableFuture<class_2561> text) implements TranslatableContainer<CompletableFuture<class_2561>, Async>
    {
        @Override
        public Async translate(TranslationDirection direction) {
            return new Async((CompletableFuture<class_2561>)this.text.thenApplyAsync(msg -> TranslatableContainer.translateAndLog(msg, direction)));
        }
    }

    public record Sync(class_2561 text) implements TranslatableContainer<class_2561, Sync>
    {
        @Override
        public Sync translate(TranslationDirection direction) {
            return new Sync(TranslatableContainer.translateAndLog(this.text, direction));
        }
    }
}

