/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.googlechat;

import io.gitlab.jfronny.commons.io.cache.FixedSizeMap;
import io.gitlab.jfronny.commons.logger.SystemLoggerPlus;
import io.gitlab.jfronny.commons.throwable.Coerce;
import io.gitlab.jfronny.commons.throwable.ThrowingRunnable;
import io.gitlab.jfronny.commons.throwable.Try;
import io.gitlab.jfronny.googlechat.GoogleChatConfig;
import io.gitlab.jfronny.googlechat.TranslationDirection;
import io.gitlab.jfronny.libjf.translate.api.Language;
import io.gitlab.jfronny.libjf.translate.api.TranslateService;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8828;

public class GoogleChat
implements ModInitializer {
    public static final String MOD_ID = "google-chat";
    public static final SystemLoggerPlus LOGGER = SystemLoggerPlus.forName((String)"google-chat");
    public static TranslateService<?> TRANSLATE_SERVICE;
    private static final boolean IS_SERVER;
    private static final TranslationDirection.Split<Map<class_2561, class_2561>> finalTexts;
    private static final TranslationDirection.Split<Map<class_7417, class_7417>> textContents;
    private static final TranslationDirection.Split<Map<String, String>> strings;
    private static final Pattern SURROUNDING_SPACE_PATTERN;

    public void onInitialize() {
        ForkJoinPool.commonPool().execute(Try.handle((ThrowingRunnable)Coerce.runnable(() -> {
            TRANSLATE_SERVICE = TranslateService.getConfigured();
        }), e -> LOGGER.error("Could not initialize translation service", e)));
    }

    public static void onConfigChange() {
        Stream.of(finalTexts, textContents, strings).flatMap(TranslationDirection.Split::stream).forEach(map -> {
            Map map2 = map;
            synchronized (map2) {
                map.clear();
            }
        });
    }

    public static class_2561 translateIfNeeded(class_2561 source, TranslationDirection direction, boolean respectRegex) {
        if (source == null) {
            return null;
        }
        if (direction.shouldSkipOutright()) {
            return source;
        }
        String sourceString = GoogleChat.toString(source);
        if (respectRegex && direction.failsRegex(sourceString)) {
            return source;
        }
        return GoogleChat.computeIfAbsent2(finalTexts.get(direction), source, t -> {
            class_5250 translated;
            class_5250 class_52502 = translated = GoogleChatConfig.Processing.desugar ? class_2561.method_43470((String)GoogleChat.translateIfNeeded(sourceString, direction, true)) : GoogleChat.doTranslateIfNeeded(t, direction);
            if (GoogleChatConfig.Advanced.debugLogs) {
                LOGGER.info("Translated {0} to {1}", new Object[]{sourceString, GoogleChat.toString((class_2561)translated)});
            }
            return switch (GoogleChatConfig.General.displayMode) {
                default -> throw new MatchException(null, null);
                case GoogleChatConfig.General.DisplayMode.REPLACE -> {
                    if (translated.method_10866().method_10969() == null) {
                        class_5250 hoverText = class_2561.method_48322((String)"google-chat.display.original", (String)"Original: %1$s", (Object[])new Object[]{t});
                        yield translated.method_27694(style -> GoogleChat.addHover(style, (class_2561)hoverText));
                    }
                    yield translated;
                }
                case GoogleChatConfig.General.DisplayMode.TOOLTIP -> {
                    class_5250 hoverText = class_2561.method_48322((String)"google-chat.display.translated", (String)"Translated: %1$s", (Object[])new Object[]{translated});
                    yield t.method_27661().method_27694(style -> GoogleChat.addHover(style, (class_2561)hoverText));
                }
                case GoogleChatConfig.General.DisplayMode.APPEND -> class_2561.method_48322((String)"google-chat.display.appended", (String)"%1$s\u00a7r \u00a77\u00a7o(Translated: %2$s\u00a7r\u00a77\u00a7o)", (Object[])new Object[]{t, translated.method_27694(style -> style.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true)))});
            };
        });
    }

    private static class_5250 doTranslateIfNeeded(class_2561 source, TranslationDirection direction) {
        class_5250 translated = class_5250.method_43477((class_7417)GoogleChat.translateIfNeeded(source.method_10851(), direction, false)).method_10862(source.method_10866());
        for (class_2561 sibling : source.method_10855()) {
            translated.method_10852((class_2561)GoogleChat.doTranslateIfNeeded(sibling, direction));
        }
        return translated;
    }

    private static String toString(class_2561 text) {
        StringBuilder sb = new StringBuilder();
        text.method_30937().accept((index, style, codePoint) -> {
            sb.append((char)codePoint);
            return true;
        });
        return sb.toString();
    }

    public static class_7417 translateIfNeeded(class_7417 source, TranslationDirection direction, boolean respectRegex) {
        if (source == null || source == class_8828.field_46625) {
            return source;
        }
        if (direction.shouldSkipOutright()) {
            return source;
        }
        String sourceString = GoogleChat.toString(source);
        if (respectRegex && direction.failsRegex(sourceString)) {
            return source;
        }
        return GoogleChat.computeIfAbsent2(textContents.get(direction), source, t -> {
            class_7417 class_74172;
            class_7417 selector1$temp = t;
            int index$2 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2588.class, class_8828.class_2585.class}, (Object)selector1$temp, index$2)) {
                case 0: {
                    class_2588 tx = (class_2588)selector1$temp;
                    Object[] args = Arrays.stream(tx.method_11023()).map(arg -> {
                        Object selector0$temp = arg;
                        int index$1 = 0;
                        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2561.class, class_7417.class, String.class}, (Object)selector0$temp, index$1)) {
                            case 0 -> {
                                class_2561 tx1 = (class_2561)selector0$temp;
                                yield GoogleChat.doTranslateIfNeeded(tx1, direction);
                            }
                            case 1 -> {
                                class_7417 tx1 = (class_7417)selector0$temp;
                                yield GoogleChat.translateIfNeeded(tx1, direction, false);
                            }
                            case 2 -> {
                                String tx1 = (String)selector0$temp;
                                yield GoogleChat.translateIfNeeded(tx1, direction, false);
                            }
                            case -1 -> null;
                            default -> {
                                if (GoogleChatConfig.Advanced.debugLogs) {
                                    LOGGER.warn("Unhandled argument type: {0} ({1}})", new Object[]{arg.getClass().toString(), arg.toString()});
                                }
                                yield arg;
                            }
                        };
                    }).toArray();
                    class_74172 = new class_2588(tx.method_11022(), GoogleChat.translateIfNeeded(tx.method_48323(), direction, false), args);
                    return class_74172;
                }
                case 1: {
                    String string;
                    class_8828.class_2585 $b$0 = (class_8828.class_2585)selector1$temp;
                    try {
                        String patt3$temp;
                        string = patt3$temp = $b$0.comp_737();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    class_74172 = new class_8828.class_2585(GoogleChat.translateIfNeeded(string, direction, false));
                    return class_74172;
                }
            }
            if (GoogleChatConfig.Advanced.debugLogs) {
                LOGGER.warn("Unhandled text type: {0} ({1}})", new Object[]{source.getClass().toString(), source.toString()});
            }
            class_74172 = t;
            return class_74172;
        });
    }

    private static String toString(class_7417 text) {
        StringBuilder sb = new StringBuilder();
        text.method_27659(asString -> {
            sb.append(asString);
            return Optional.empty();
        });
        return sb.toString();
    }

    private static class_2583 addHover(class_2583 style, class_2561 hoverText) {
        return style.method_10949((class_2568)new class_2568.class_10613(hoverText));
    }

    public static String translateIfNeeded(String source, TranslationDirection direction, boolean respectRegex) {
        if (source == null || source.isBlank()) {
            return source;
        }
        if (direction.shouldSkipOutright()) {
            return source;
        }
        if (respectRegex && direction.failsRegex(source)) {
            return source;
        }
        return GoogleChat.computeIfAbsent2(strings.get(direction), source, t -> {
            try {
                Matcher m = SURROUNDING_SPACE_PATTERN.matcher(source);
                if (!m.find()) {
                    return source;
                }
                TranslateService<?> svc = TRANSLATE_SERVICE;
                if (svc == null) {
                    throw new NullPointerException("Translate service uninitialized");
                }
                Language sourceLang = svc.parseLang(direction.source());
                Language targetLang = svc.parseLang(direction.target());
                return m.group(1) + svc.translate(m.group(2), sourceLang, targetLang) + m.group(3);
            }
            catch (Throwable e) {
                LOGGER.error("Could not translate text: {0}", e, new Object[]{source});
                return source;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K, V> V computeIfAbsent2(Map<K, V> map, K key, Function<K, V> compute) {
        if (!GoogleChatConfig.Advanced.async && !IS_SERVER) {
            return map.computeIfAbsent(key, compute);
        }
        Map<K, V> map2 = map;
        synchronized (map2) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            V value = compute.apply(key);
            map.put(key, value);
            return value;
        }
    }

    static {
        IS_SERVER = FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
        finalTexts = TranslationDirection.Split.of(() -> new FixedSizeMap(GoogleChatConfig.Advanced.cacheSize));
        textContents = TranslationDirection.Split.of(() -> new FixedSizeMap(GoogleChatConfig.Advanced.cacheSize));
        strings = TranslationDirection.Split.of(() -> new FixedSizeMap(GoogleChatConfig.Advanced.cacheSize));
        SURROUNDING_SPACE_PATTERN = Pattern.compile("^(\\s*)(.*\\S+)(\\s*)$", 8);
    }
}

